/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import ru.curs.celesta.score.AbstractSelectStmt;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.Parameter;
import ru.curs.celesta.score.ParameterizedViewSelectStmt;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.View;

public final class ParameterizedView
extends View {
    final Map<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
    final List<String> parameterRefsWithOrder = new ArrayList<String>();
    private final List<Supplier<Set<String>>> unusedParametersSuppliers = new ArrayList<Supplier<Set<String>>>();

    public ParameterizedView(GrainPart grainPart, String name) throws ParseException {
        super(grainPart, name);
    }

    @Override
    String viewType() {
        return "function";
    }

    @Override
    AbstractSelectStmt newSelectStatement() {
        ParameterizedViewSelectStmt result = new ParameterizedViewSelectStmt(this);
        this.unusedParametersSuppliers.add(result::getUnusedParameters);
        return result;
    }

    public void addParameter(Parameter parameter) throws ParseException {
        if (parameter == null) {
            throw new IllegalArgumentException();
        }
        if (parameter.getName() == null || parameter.getName().isEmpty()) {
            throw new ParseException(String.format("%s '%s' contains a parameter with undefined name.", this.viewType(), this.getName()));
        }
        if (this.parameters.containsKey(parameter.getName())) {
            throw new ParseException(String.format("%s '%s' already contains parameter with name '%s'. Use unique names for %s parameters.", this.viewType(), this.getName(), parameter.getName(), this.viewType()));
        }
        this.parameters.put(parameter.getName(), parameter);
    }

    public Map<String, Parameter> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public List<String> getParameterRefsWithOrder() {
        return this.parameterRefsWithOrder;
    }

    @Override
    void finalizeParsing() throws ParseException {
        super.finalizeParsing();
        HashSet unused = new HashSet(this.unusedParametersSuppliers.get(0).get());
        for (int i = 1; i < this.unusedParametersSuppliers.size(); ++i) {
            unused.retainAll((Collection)this.unusedParametersSuppliers.get(i).get());
        }
        if (!unused.isEmpty()) {
            String unusedParametersStr = String.join((CharSequence)", ", unused);
            throw new ParseException(String.format("%s '%s' contains not used parameters %s.", this.viewType(), this.getName(), unusedParametersStr));
        }
    }
}

