/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import ru.curs.celesta.score.Between;
import ru.curs.celesta.score.BinaryTermOp;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.In;
import ru.curs.celesta.score.Lower;
import ru.curs.celesta.score.NotExpr;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Relop;
import ru.curs.celesta.score.Sum;
import ru.curs.celesta.score.UnaryMinus;
import ru.curs.celesta.score.Upper;
import ru.curs.celesta.score.ViewColumnType;

final class TypeChecker
extends ExprVisitor {
    TypeChecker() {
    }

    @Override
    void visitBetween(Between expr) throws ParseException {
        ViewColumnType t = expr.getLeft().getMeta().getColumnType();
        if (t != ViewColumnType.DATE && t != ViewColumnType.REAL && t != ViewColumnType.INT && t != ViewColumnType.TEXT) {
            throw new ParseException(String.format("Wrong expression '%s': type %s cannot be used in ...BETWEEN...AND... expression.", expr.getCSQL(), t.toString()));
        }
        expr.getRight1().assertType(t);
        expr.getRight2().assertType(t);
    }

    @Override
    void visitBinaryTermOp(BinaryTermOp expr) throws ParseException {
        ViewColumnType t = expr.getOperator() == 4 ? ViewColumnType.TEXT : ViewColumnType.REAL;
        for (Expr e : expr.getOperands()) {
            e.assertType(t);
        }
    }

    @Override
    void visitIn(In expr) throws ParseException {
        ViewColumnType t = expr.getLeft().getMeta().getColumnType();
        if (t == ViewColumnType.DATE || t == ViewColumnType.REAL || t == ViewColumnType.INT || t == ViewColumnType.TEXT) {
            for (Expr operand : expr.getOperands()) {
                operand.assertType(t);
            }
        } else {
            throw new ParseException(String.format("Wrong expression '%s': type %s cannot be used in ...IN(...) expression.", expr.getCSQL(), t.toString()));
        }
    }

    @Override
    void visitRelop(Relop expr) throws ParseException {
        ViewColumnType t = expr.getLeft().getMeta().getColumnType();
        if (t == ViewColumnType.DATE || t == ViewColumnType.REAL || t == ViewColumnType.DECIMAL || t == ViewColumnType.INT || t == ViewColumnType.TEXT) {
            expr.getRight().assertType(t);
            if (expr.getRelop() == 6) {
                expr.getLeft().assertType(ViewColumnType.TEXT);
            }
        } else if (t == ViewColumnType.BIT && expr.getRelop() == 5) {
            if (expr.getRight().getMeta().getColumnType() != ViewColumnType.BIT) {
                throw new ParseException(String.format("Wrong expression '%s': BIT field can be compared with another BIT field or TRUE/FALSE constants only.", expr.getCSQL()));
            }
        } else {
            throw new ParseException(String.format("Wrong expression '%s': type %s cannot be used in comparisions.", expr.getCSQL(), t.toString()));
        }
    }

    @Override
    void visitUnaryMinus(UnaryMinus expr) throws ParseException {
        expr.getExpr().assertType(ViewColumnType.REAL);
    }

    @Override
    void visitNotExpr(NotExpr expr) throws ParseException {
        expr.getExpr().assertType(ViewColumnType.LOGIC);
    }

    @Override
    void visitSum(Sum expr) throws ParseException {
        expr.term.assertType(ViewColumnType.REAL);
    }

    @Override
    void visitUpper(Upper expr) throws ParseException {
        expr.getArg().assertType(ViewColumnType.TEXT);
    }

    @Override
    void visitLower(Lower expr) throws ParseException {
        expr.getArg().assertType(ViewColumnType.TEXT);
    }
}

