/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import ru.curs.celesta.score.AbstractSelectStmt;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.ViewColumnType;

class ViewSelectStmt
extends AbstractSelectStmt {
    protected Expr whereCondition;

    public ViewSelectStmt(AbstractView view) {
        super(view);
    }

    @Override
    void setWhereCondition(Expr whereCondition) throws ParseException {
        if (whereCondition != null) {
            ArrayList<TableRef> t = new ArrayList<TableRef>(this.tables.values());
            whereCondition.resolveFieldRefs(t);
            whereCondition.assertType(ViewColumnType.LOGIC);
        }
        this.whereCondition = whereCondition;
    }

    @Override
    void finalizeParsing() throws ParseException {
        this.finalizeColumnsParsing();
        this.finalizeWhereConditionParsing();
        this.finalizeGroupByParsing();
    }

    void finalizeWhereConditionParsing() throws ParseException {
        ArrayList<TableRef> t = new ArrayList<TableRef>(this.tables.values());
        if (this.whereCondition != null) {
            this.whereCondition.resolveFieldRefs(t);
            this.whereCondition.validateTypes();
        }
    }

    @Override
    final void writeWherePart(PrintWriter bw, SQLGenerator gen) throws IOException {
        if (this.whereCondition != null) {
            bw.println();
            bw.write("  where ");
            bw.write(gen.generateSQL(this.whereCondition));
        }
    }
}

