/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.score.ParseException;

public abstract class IdentifierParser {
    public static final String PLAIN_NAME_PATTERN_STR = "[a-zA-Z_][0-9a-zA-Z_]*";

    public final String parse(String name) throws ParseException {
        this.validate(name);
        return this.strip(name);
    }

    void validate(String name) throws ParseException {
        Matcher m = this.getNamePattern().matcher(name);
        if (!m.matches()) {
            throw new ParseException(String.format("Invalid identifier: '%s'.", name));
        }
    }

    abstract String strip(String var1);

    abstract Pattern getNamePattern();
}

