/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.ConnectionPool;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.QueryBuildingHelper;
import ru.curs.celesta.dbutils.adaptors.OpenSourceDbAdaptor;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlConsumer;
import ru.curs.celesta.dbutils.adaptors.ddl.DdlGenerator;
import ru.curs.celesta.dbutils.adaptors.ddl.PostgresDdlGenerator;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbFkInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.dbutils.meta.DbPkInfo;
import ru.curs.celesta.dbutils.meta.DbSequenceInfo;
import ru.curs.celesta.dbutils.query.FromClause;
import ru.curs.celesta.dbutils.stmt.ParameterSetter;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.TableElement;

public final class PostgresAdaptor
extends OpenSourceDbAdaptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresAdaptor.class);
    private static final Pattern HEX_STRING = Pattern.compile("'\\\\x([0-9A-Fa-f]+)'");

    public PostgresAdaptor(ConnectionPool connectionPool, DdlConsumer ddlConsumer) {
        super(connectionPool, ddlConsumer);
    }

    @Override
    DdlGenerator getDdlGenerator() {
        return new PostgresDdlGenerator(this);
    }

    /*
     * Exception decompiling
     */
    @Override
    boolean userTablesExist(Connection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getCurrentIdent(Connection conn, BasicTable t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public PreparedStatement getInsertRecordStatement(Connection conn, BasicTable t, boolean[] nullsMask, List<ParameterSetter> program) {
        Iterator<String> columns = t.getColumns().keySet().iterator();
        StringBuilder fields = new StringBuilder();
        StringBuilder params = new StringBuilder();
        for (int i = 0; i < t.getColumns().size(); ++i) {
            String c = columns.next();
            if (nullsMask[i]) continue;
            if (params.length() > 0) {
                fields.append(", ");
                params.append(", ");
            }
            params.append("?");
            fields.append('\"');
            fields.append(c);
            fields.append('\"');
            program.add(ParameterSetter.create(i, (QueryBuildingHelper)this));
        }
        String returning = "";
        for (Column column : t.getColumns().values()) {
            IntegerColumn ic;
            if (!(column instanceof IntegerColumn) || (ic = (IntegerColumn)column).getSequence() == null) continue;
            returning = " returning " + column.getQuotedName();
            break;
        }
        String sql = fields.length() == 0 && params.length() == 0 ? String.format("insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " default values %s;", returning) : String.format("insert into " + this.tableString(t.getGrain().getName(), t.getName()) + " (%s) values (%s)%s;", fields.toString(), params.toString(), returning);
        return PostgresAdaptor.prepareStatement(conn, sql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DbColumnInfo getColumnInfo(Connection conn, Column<?> c) {
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(null, c.getParentTable().getGrain().getName().replace("\"", ""), c.getParentTable().getName().replace("\"", ""), c.getName().replace("\"", ""));){
                if (rs.next()) {
                    Object defaultBody2;
                    DbColumnInfo result = new DbColumnInfo();
                    result.setName(rs.getString("COLUMN_NAME"));
                    String typeName = rs.getString("TYPE_NAME");
                    if ("serial".equalsIgnoreCase(typeName)) {
                        result.setType(IntegerColumn.class);
                        result.setNullable(rs.getInt("NULLABLE") != 0);
                        String defaultBody2 = rs.getString("COLUMN_DEF");
                        Pattern p = Pattern.compile("nextval\\('[\"]?[^\"]+[\"]?\\.[\"]?([^\"]+)+[\"]?'::regclass\\)");
                        Matcher m = p.matcher(defaultBody2);
                        if (m.matches()) {
                            String sequenceName = m.group(1);
                            result.setDefaultValue("NEXTVAL(" + sequenceName + ")");
                        }
                        DbColumnInfo dbColumnInfo = result;
                        return dbColumnInfo;
                    }
                    if ("text".equalsIgnoreCase(typeName)) {
                        result.setType(StringColumn.class);
                        result.setMax(true);
                    } else {
                        defaultBody2 = COLUMN_CLASSES.iterator();
                        while (defaultBody2.hasNext()) {
                            Class cc = (Class)defaultBody2.next();
                            if (!this.getColumnDefiner(cc).dbFieldType().equalsIgnoreCase(typeName)) continue;
                            result.setType(cc);
                            break;
                        }
                    }
                    result.setNullable(rs.getInt("NULLABLE") != 0);
                    if (result.getType() == StringColumn.class || result.getType() == DecimalColumn.class) {
                        result.setLength(rs.getInt("COLUMN_SIZE"));
                    }
                    if (result.getType() == DecimalColumn.class) {
                        result.setScale(rs.getInt("DECIMAL_DIGITS"));
                    }
                    if ((defaultBody2 = rs.getString("COLUMN_DEF")) != null) {
                        defaultBody2 = this.modifyDefault(result, (String)defaultBody2);
                        result.setDefaultValue((String)defaultBody2);
                    }
                    DbColumnInfo dbColumnInfo = result;
                    return dbColumnInfo;
                }
                DbColumnInfo dbColumnInfo = null;
                return dbColumnInfo;
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
    }

    private String modifyDefault(DbColumnInfo ci, String defaultBody) {
        Matcher m;
        String result = defaultBody;
        if (DateTimeColumn.class == ci.getType()) {
            if ("now()".equalsIgnoreCase(defaultBody)) {
                result = "GETDATE()";
            } else {
                Matcher m2 = DATEPATTERN.matcher(defaultBody);
                m2.find();
                result = String.format("'%s%s%s'", m2.group(1), m2.group(2), m2.group(3));
            }
        } else if (BooleanColumn.class == ci.getType()) {
            result = "'" + defaultBody.toUpperCase() + "'";
        } else if (StringColumn.class == ci.getType()) {
            if (result.endsWith("::text")) {
                result = result.substring(0, result.length() - "::text".length());
            } else if (result.endsWith("::character varying")) {
                result = result.substring(0, result.length() - "::character varying".length());
            }
        } else if (BinaryColumn.class == ci.getType() && (m = HEX_STRING.matcher(defaultBody)).find()) {
            result = "0x" + m.group(1).toUpperCase();
        }
        return result;
    }

    @Override
    public String getInFilterClause(DataGrainElement dge, DataGrainElement otherDge, List<String> fields, List<String> otherFields, String otherWhere) {
        String template = "( %s ) IN (SELECT %s FROM %s WHERE %s)";
        String fieldsStr = String.join((CharSequence)",", fields.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()));
        String otherFieldsStr = String.join((CharSequence)",", otherFields.stream().map(s -> "\"" + s + "\"").collect(Collectors.toList()));
        String otherTableStr = this.tableString(otherDge.getGrain().getName(), otherDge.getName());
        String result = String.format(template, fieldsStr, otherFieldsStr, otherTableStr, otherWhere);
        return result;
    }

    @Override
    String getLimitedSQL(FromClause from, String whereClause, String orderBy, long offset, long rowCount, Set<String> fields) {
        if (offset == 0L && rowCount == 0L) {
            throw new IllegalArgumentException();
        }
        String sql = offset == 0L ? this.getSelectFromOrderBy(from, whereClause, orderBy, fields) + String.format(" limit %d", rowCount) : (rowCount == 0L ? this.getSelectFromOrderBy(from, whereClause, orderBy, fields) + String.format(" limit all offset %d", offset) : this.getSelectFromOrderBy(from, whereClause, orderBy, fields) + String.format(" limit %d offset %d", rowCount, offset));
        return sql;
    }

    @Override
    public List<String> getParameterizedViewList(Connection conn, Grain g) {
        String sql = String.format(" SELECT r.routine_name FROM INFORMATION_SCHEMA.ROUTINES r WHERE r.routine_schema = '%s' AND r.routine_type='FUNCTION' AND exists (select * from pg_proc p\n        where p.proname = r.routine_name\n        AND upper(pg_get_function_result(p.oid)) like upper('%%table%%'))", g.getName());
        LinkedList<String> result = new LinkedList<String>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Cannot get parameterized views list: %s", e.toString());
        }
        return result;
    }

    @Override
    public DbPkInfo getPKInfo(Connection conn, TableElement t) {
        String sql = String.format("SELECT i.relname AS indexname, i.oid, array_length(x.indkey, 1) as colcount FROM pg_index x INNER JOIN pg_class c ON c.oid = x.indrelid INNER JOIN pg_class i ON i.oid = x.indexrelid INNER JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relkind = 'r'::\"char\" AND i.relkind = 'i'::\"char\" and n.nspname = '%s' and c.relname = '%s' and x.indisprimary", t.getGrain().getName().replace("\"", ""), t.getName().replace("\"", ""));
        DbPkInfo result = new DbPkInfo(this);
        try (Statement stmt = conn.createStatement();
             PreparedStatement stmt2 = conn.prepareStatement("select pg_get_indexdef(?, ?, false)");
             ResultSet rs = stmt.executeQuery(sql);){
            if (rs.next()) {
                String indName = rs.getString("indexname");
                int colCount = rs.getInt("colcount");
                int oid = rs.getInt("oid");
                result.setName(indName);
                stmt2.setInt(1, oid);
                for (int i = 1; i <= colCount; ++i) {
                    stmt2.setInt(2, i);
                    try (ResultSet rs2 = stmt2.executeQuery();){
                        rs2.next();
                        String colName = rs2.getString(1);
                        Matcher m = QUOTED_NAME.matcher(colName);
                        m.matches();
                        result.addColumnName(m.group(1));
                        continue;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Could not get indices information: %s", e.getMessage());
        }
        return result;
    }

    @Override
    public List<DbFkInfo> getFKInfo(Connection conn, Grain g) {
        String sql = String.format("SELECT RC.CONSTRAINT_SCHEMA AS GRAIN   , KCU1.CONSTRAINT_NAME AS FK_CONSTRAINT_NAME   , KCU1.TABLE_NAME AS FK_TABLE_NAME   , KCU1.COLUMN_NAME AS FK_COLUMN_NAME   , KCU2.TABLE_SCHEMA AS REF_GRAIN   , KCU2.TABLE_NAME AS REF_TABLE_NAME   , RC.UPDATE_RULE, RC.DELETE_RULE FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS RC INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU1    ON  KCU1.CONSTRAINT_CATALOG = RC.CONSTRAINT_CATALOG   AND KCU1.CONSTRAINT_SCHEMA  = RC.CONSTRAINT_SCHEMA   AND KCU1.CONSTRAINT_NAME    = RC.CONSTRAINT_NAME INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE KCU2   ON  KCU2.CONSTRAINT_CATALOG = RC.UNIQUE_CONSTRAINT_CATALOG   AND KCU2.CONSTRAINT_SCHEMA  = RC.UNIQUE_CONSTRAINT_SCHEMA   AND KCU2.CONSTRAINT_NAME    = RC.UNIQUE_CONSTRAINT_NAME   AND KCU2.ORDINAL_POSITION   = KCU1.ORDINAL_POSITION WHERE RC.CONSTRAINT_SCHEMA = '%s' ORDER BY KCU1.CONSTRAINT_NAME, KCU1.ORDINAL_POSITION", g.getName());
        LOGGER.trace(sql);
        LinkedList<DbFkInfo> result = new LinkedList<DbFkInfo>();
        try (Statement stmt = conn.createStatement();){
            DbFkInfo i = null;
            try (ResultSet rs = stmt.executeQuery(sql);){
                while (rs.next()) {
                    String fkName = rs.getString("FK_CONSTRAINT_NAME");
                    if (i == null || !i.getName().equals(fkName)) {
                        i = new DbFkInfo(fkName);
                        result.add(i);
                        i.setTableName(rs.getString("FK_TABLE_NAME"));
                        i.setRefGrainName(rs.getString("REF_GRAIN"));
                        i.setRefTableName(rs.getString("REF_TABLE_NAME"));
                        i.setUpdateRule(PostgresAdaptor.getFKRule(rs.getString("UPDATE_RULE")));
                        i.setDeleteRule(PostgresAdaptor.getFKRule(rs.getString("DELETE_RULE")));
                    }
                    i.getColumnNames().add(rs.getString("FK_COLUMN_NAME"));
                }
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, DbIndexInfo> getIndices(Connection conn, Grain g) {
        String sql = String.format("SELECT c.relname AS tablename, i.relname AS indexname, i.oid, array_length(x.indkey, 1) as colcount FROM pg_index x INNER JOIN pg_class c ON c.oid = x.indrelid INNER JOIN pg_class i ON i.oid = x.indexrelid INNER JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relkind = 'r'::\"char\" AND i.relkind = 'i'::\"char\" and n.nspname = '%s' and x.indisunique = false;", g.getName());
        HashMap<String, DbIndexInfo> result = new HashMap<String, DbIndexInfo>();
        try {
            Statement stmt = conn.createStatement();
            PreparedStatement stmt2 = conn.prepareStatement("select pg_get_indexdef(?, ?, false)");
            try {
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String tabName = rs.getString("tablename");
                    String indName = rs.getString("indexname");
                    if (indName.endsWith("__vpo")) continue;
                    DbIndexInfo ii = new DbIndexInfo(tabName, indName);
                    result.put(indName, ii);
                    int colCount = rs.getInt("colcount");
                    int oid = rs.getInt("oid");
                    stmt2.setInt(1, oid);
                    for (int i = 1; i <= colCount; ++i) {
                        stmt2.setInt(2, i);
                        try (ResultSet rs2 = stmt2.executeQuery();){
                            rs2.next();
                            String colName = rs2.getString(1);
                            Matcher m = QUOTED_NAME.matcher(colName);
                            m.matches();
                            ii.getColumnNames().add(m.group(1));
                            continue;
                        }
                    }
                }
            }
            finally {
                stmt.close();
                stmt2.close();
            }
        }
        catch (SQLException e) {
            throw new CelestaException("Could not get indices information: %s", e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSysObjects(Connection conn, String sysSchemaName) {
        String sql = "CREATE OR REPLACE FUNCTION " + sysSchemaName + ".recversion_check()  RETURNS trigger AS $BODY$ BEGIN\n    IF (OLD.recversion = NEW.recversion) THEN\n       NEW.recversion = NEW.recversion + 1;\n     ELSE\n       RAISE EXCEPTION 'record version check failure';\n    END IF;    RETURN NEW; END; $BODY$\n  LANGUAGE plpgsql VOLATILE COST 100;";
        try (Statement stmt = conn.createStatement();){
            stmt.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new CelestaException("Could not create or replace " + sysSchemaName + ".recversion_check() function: %s", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean triggerExists(Connection conn, TriggerQuery query) throws SQLException {
        String sql = String.format("select count(*) from information_schema.triggers where         event_object_schema = '%s' and event_object_table= '%s'        and trigger_name = '%s'", query.getSchema().replace("\"", ""), query.getTableName().replace("\"", ""), query.getName());
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sql);
            rs.next();
            boolean result = rs.getInt(1) > 0;
            rs.close();
            boolean bl = result;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getDBPid(Connection conn) {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery("select pg_backend_pid();");){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public ZonedDateTime prepareZonedDateTimeForParameterSetter(Connection conn, ZonedDateTime z) {
        ZoneOffset systemOffset = OffsetDateTime.now().getOffset();
        ZoneOffset offset = z.getOffset();
        int offsetDifInSeconds = systemOffset.getTotalSeconds() - offset.getTotalSeconds();
        return z.plusSeconds(offsetDifInSeconds);
    }

    @Override
    String getSelectTriggerBodySql(TriggerQuery query) {
        String sql = String.format("select DISTINCT(prosrc)\n from pg_trigger, pg_proc, information_schema.triggers\n where\n pg_proc.oid=pg_trigger.tgfoid\n and information_schema.triggers.trigger_schema='%s'\n and information_schema.triggers.event_object_table='%s' and pg_trigger.tgname = '%s'\n", query.getSchema(), query.getTableName(), query.getName());
        return sql;
    }

    @Override
    public DBType getType() {
        return DBType.POSTGRESQL;
    }

    @Override
    public boolean supportsCortegeComparing() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DbSequenceInfo getSequenceInfo(Connection conn, SequenceElement s) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ boolean lambda$getCurrentIdent$2(IntegerColumn ic) {
        return ic.getSequence() != null;
    }

    private static /* synthetic */ IntegerColumn lambda$getCurrentIdent$1(Column c) {
        return (IntegerColumn)c;
    }

    private static /* synthetic */ boolean lambda$getCurrentIdent$0(Column c) {
        return c instanceof IntegerColumn;
    }
}

