/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.FireBirdColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DecimalColumn;

class FireBirdDecimalColumnDefiner
extends FireBirdColumnDefiner {
    FireBirdDecimalColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "DECIMAL";
    }

    @Override
    public String getInternalDefinition(Column c) {
        DecimalColumn dc = (DecimalColumn)c;
        String fieldType = String.format("%s(%s,%s)", this.dbFieldType(), dc.getPrecision(), dc.getScale());
        return FireBirdDecimalColumnDefiner.join(c.getQuotedName(), fieldType);
    }

    public String getDefaultDefinition(Column c) {
        DecimalColumn dc = (DecimalColumn)c;
        String defaultStr = "";
        if (dc.getDefaultValue() != null) {
            defaultStr = "default " + dc.getDefaultValue();
        }
        return defaultStr;
    }
}

