/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DecimalColumn;

class H2DecimalColumnDefiner
extends ColumnDefiner {
    H2DecimalColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "DECIMAL";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        DecimalColumn dc = (DecimalColumn)c;
        String fieldType = String.format("%s(%s,%s)", this.dbFieldType(), dc.getPrecision(), dc.getScale());
        return H2DecimalColumnDefiner.join(c.getQuotedName(), fieldType, this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        DecimalColumn dc = (DecimalColumn)c;
        String defaultStr = "";
        if (dc.getDefaultValue() != null) {
            defaultStr = "default " + dc.getDefaultValue();
        }
        return defaultStr;
    }
}

