/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.MsSqlColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.SequenceElement;

class MsSqlIntegerColumnDefiner
extends MsSqlColumnDefiner {
    MsSqlIntegerColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "int";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        return MsSqlIntegerColumnDefiner.join(c.getQuotedName(), this.dbFieldType(), this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        IntegerColumn ic = (IntegerColumn)c;
        SequenceElement s = ic.getSequence();
        if (s != null) {
            return this.msSQLDefault(c) + "next value for " + s.getGrain().getQuotedName() + "." + s.getQuotedName();
        }
        if (ic.getDefaultValue() != null) {
            return this.msSQLDefault(c) + ic.getDefaultValue();
        }
        return "";
    }

    @Override
    public String getLightDefaultDefinition(Column<?> c) {
        IntegerColumn ic = (IntegerColumn)c;
        if (ic.getDefaultValue() != null) {
            return "default " + ic.getDefaultValue();
        }
        return "";
    }
}

