/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.OraColumnDefiner;
import ru.curs.celesta.dbutils.adaptors.function.OraFunctions;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;

class OraBooleanColumnDefiner
extends OraColumnDefiner {
    OraBooleanColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "number";
    }

    @Override
    public String getInternalDefinition(Column<?> c) {
        return OraBooleanColumnDefiner.join(c.getQuotedName(), this.dbFieldType());
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        BooleanColumn ic = (BooleanColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = "default " + (ic.getDefaultValue() != false ? "1" : "0");
        }
        return defaultStr;
    }

    @Override
    public String getFullDefinition(Column<?> c) {
        String check = String.format("constraint %s check (%s in (0, 1))", OraFunctions.getBooleanCheckName(c), c.getQuotedName());
        return OraBooleanColumnDefiner.join(this.getInternalDefinition(c), this.getDefaultDefinition(c), this.nullable(c), check);
    }
}

