/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.SequenceElement;

class PostgresIntegerColumnDefiner
extends ColumnDefiner {
    PostgresIntegerColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "int4";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        return PostgresIntegerColumnDefiner.join(c.getQuotedName(), this.dbFieldType(), this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        IntegerColumn ic = (IntegerColumn)c;
        String defaultStr = "";
        SequenceElement s = ic.getSequence();
        if (s != null) {
            defaultStr = "default nextval('" + s.getGrain().getQuotedName() + "." + s.getQuotedName() + "')";
        } else if (ic.getDefaultValue() != null) {
            defaultStr = "default " + ic.getDefaultValue();
        }
        return defaultStr;
    }
}

