/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.meta;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import ru.curs.celesta.score.Index;

public final class DbIndexInfo {
    private final String tableName;
    private final String indexName;
    private final List<String> columnNames = new LinkedList<String>();

    public DbIndexInfo(String tableName, String indexName) {
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public String toString() {
        return String.format("%s.%s", this.tableName, this.indexName);
    }

    public boolean reflects(Index ind) {
        boolean result;
        boolean bl = result = ind.getName().equals(this.indexName) && ind.getTable().getName().equals(this.tableName);
        if (!result) {
            return false;
        }
        List<String> dbIndexCols = this.columnNames;
        Set<String> metaIndexCols = ind.getColumns().keySet();
        Iterator i1 = dbIndexCols.iterator();
        Iterator i2 = metaIndexCols.iterator();
        boolean bl2 = result = dbIndexCols.size() == metaIndexCols.size();
        if (!result) {
            return false;
        }
        while (i1.hasNext() && result) {
            result = ((String)i1.next()).equals(i2.next());
        }
        return result;
    }
}

