/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.Aggregate;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.FieldRef;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.TableRef;

public abstract class AbstractSelectStmt {
    final AbstractView view;
    final Map<String, Expr> columns = new LinkedHashMap<String, Expr>();
    final Map<String, FieldRef> groupByColumns = new LinkedHashMap<String, FieldRef>();
    boolean distinct;
    final Map<String, TableRef> tables = new LinkedHashMap<String, TableRef>();

    public AbstractSelectStmt(AbstractView view) {
        this.view = view;
    }

    void writeSelectPart(PrintWriter bw, SQLGenerator gen, AbstractView.BWWrapper bww) throws IOException {
        bww.append("  select ", bw);
        if (this.distinct) {
            bww.append("distinct ", bw);
        }
        boolean cont = false;
        for (Map.Entry<String, Expr> e : this.columns.entrySet()) {
            if (cont) {
                bww.append(", ", bw);
            }
            String st = gen.generateSQL(e.getValue()) + " as ";
            st = gen.quoteNames() ? st + "\"" + e.getKey() + "\"" : st + e.getKey();
            bww.append(st, bw);
            cont = true;
        }
        bw.println();
    }

    void writeFromPart(PrintWriter bw, SQLGenerator gen) throws IOException {
        bw.write("  from ");
        boolean cont = false;
        for (TableRef tRef : this.tables.values()) {
            if (cont) {
                bw.println();
                bw.printf("    %s ", tRef.getJoinType().toString());
                bw.write("join ");
            }
            bw.write(gen.tableName(tRef));
            if (cont) {
                bw.write(" on ");
                bw.write(gen.generateSQL(tRef.getOnExpr()));
            }
            cont = true;
        }
    }

    void writeWherePart(PrintWriter bw, SQLGenerator gen) throws IOException {
    }

    void writeGroupByPart(PrintWriter bw, SQLGenerator gen) throws IOException {
        if (!this.groupByColumns.isEmpty()) {
            bw.println();
            bw.write(" group by ");
            int countOfProcessed = 0;
            for (Expr expr : this.groupByColumns.values()) {
                bw.write(gen.generateSQL(expr));
                if (++countOfProcessed == this.groupByColumns.size()) continue;
                bw.write(", ");
            }
        }
    }

    void addColumn(String alias, Expr expr) throws ParseException {
        if (expr == null) {
            throw new IllegalArgumentException();
        }
        if (alias == null || alias.isEmpty()) {
            throw new ParseException(String.format("%s '%s' contains a column with undefined alias.", this.view.viewType(), this.view.getName()));
        }
        alias = this.view.getGrain().getScore().getIdentifierParser().parse(alias);
        if (this.columns.containsKey(alias)) {
            throw new ParseException(String.format("%s '%s' already contains column with name or alias '%s'. Use unique aliases for %s columns.", this.view.viewType(), this.view.getName(), alias, this.view.viewType()));
        }
        this.columns.put(alias, expr);
    }

    void addGroupByColumn(FieldRef fr) throws ParseException {
        if (fr == null) {
            throw new IllegalArgumentException();
        }
        String alias = fr.getColumnName();
        if (this.groupByColumns.containsKey(alias)) {
            throw new ParseException(String.format("Duplicate column '%s' in GROUP BY expression for %s '%s.%s'.", alias, this.view.viewType(), this.view.getGrain().getName(), this.view.getName()));
        }
        Expr existedColumn = this.columns.get(fr.getColumnName());
        if (existedColumn == null) {
            throw new ParseException("Couldn't resolve column ref " + fr.getColumnName());
        }
        if (existedColumn.getClass().equals(FieldRef.class)) {
            FieldRef existedColumnFr = (FieldRef)existedColumn;
            fr.setTableNameOrAlias(existedColumnFr.getTableNameOrAlias());
            fr.setColumnName(existedColumnFr.getColumnName());
            fr.setColumn(existedColumnFr.getColumn());
        }
        this.groupByColumns.put(alias, fr);
    }

    void addFromTableRef(TableRef ref) throws ParseException {
        if (ref == null) {
            throw new IllegalArgumentException();
        }
        String alias = ref.getAlias();
        if (alias == null || alias.isEmpty()) {
            throw new ParseException(String.format("%s '%s' contains a table with undefined alias.", this.view.viewType(), this.view.getName()));
        }
        if (this.tables.containsKey(alias)) {
            throw new ParseException(String.format("%s, '%s' already contains table with name or alias '%s'. Use unique aliases for %s tables.", this.view.viewType(), this.view.getName(), alias, this.view.viewType()));
        }
        this.tables.put(alias, ref);
        Expr onCondition = ref.getOnExpr();
        if (onCondition != null) {
            onCondition.resolveFieldRefs(new ArrayList<TableRef>(this.tables.values()));
            onCondition.validateTypes();
        }
    }

    void finalizeColumnsParsing() throws ParseException {
        ArrayList<TableRef> t = new ArrayList<TableRef>(this.tables.values());
        for (Expr e : this.columns.values()) {
            e.resolveFieldRefs(t);
            e.validateTypes();
        }
    }

    abstract void setWhereCondition(Expr var1) throws ParseException;

    abstract void finalizeParsing() throws ParseException;

    void finalizeGroupByParsing() throws ParseException {
        boolean hasErrorOpt;
        Set aggregateAliases = this.columns.entrySet().stream().filter(e -> e.getValue() instanceof Aggregate).map(Map.Entry::getKey).collect(Collectors.toSet());
        if ((!aggregateAliases.isEmpty() && aggregateAliases.size() != this.columns.size() || !this.groupByColumns.isEmpty()) && (hasErrorOpt = this.columns.entrySet().stream().anyMatch(e -> !(e.getValue() instanceof Aggregate) && !this.groupByColumns.containsKey(e.getKey())))) {
            throw new ParseException(String.format("%s '%s.%s' contains a column(s) which was not specified in aggregate function and GROUP BY expression.", this.view.viewType(), this.view.getGrain().getName(), this.view.getName()));
        }
    }

    boolean isDistinct() {
        return this.distinct;
    }

    void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    final Grain getGrain() {
        return this.view.getGrain();
    }
}

