/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.CelestaDocUtils;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.NamedElementHolder;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.TableElement;

public abstract class BasicTable
extends DataGrainElement
implements TableElement {
    final NamedElementHolder<Column<?>> pk = new NamedElementHolder<Column<?>>(){

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Column '%s' defined more than once for primary key in table '%s'.", name, BasicTable.this.getName());
        }
    };
    private final NamedElementHolder<Column<?>> columns = new NamedElementHolder<Column<?>>(){

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Column '%s' defined more than once in table '%s'.", name, BasicTable.this.getName());
        }
    };
    private final boolean canHaveEmptyPK;
    private final Set<ForeignKey> fKeys = new LinkedHashSet<ForeignKey>();
    private final Set<Index> indices = new HashSet<Index>();
    private boolean pkFinalized = false;
    private boolean autoUpdate = true;
    private String pkConstraintName;

    protected BasicTable(GrainPart grainPart, String name, boolean canHaveEmptyPK) throws ParseException {
        super(grainPart, name);
        this.getGrain().addElement(this);
        this.canHaveEmptyPK = canHaveEmptyPK;
    }

    @Override
    public Map<String, Column<?>> getColumns() {
        return this.columns.getElements();
    }

    @Override
    public final Column<?> getColumn(String colName) throws ParseException {
        Column<?> result = this.columns.get(colName);
        if (result == null) {
            throw new ParseException(String.format("Column '%s' not found in table '%s.%s'", colName, this.getGrain().getName(), this.getName()));
        }
        return result;
    }

    @Override
    public final Map<String, Column<?>> getPrimaryKey() {
        return this.pk.getElements();
    }

    @Override
    public void addColumn(Column<?> column) throws ParseException {
        if (column.getParentTable() != this) {
            throw new IllegalArgumentException();
        }
        this.getGrain().modify();
        this.columns.addElement(column);
    }

    public final String toString() {
        return "name: " + this.getName() + " " + this.columns.toString();
    }

    public void setPK(String ... columnNames) throws ParseException {
        if (columnNames == null || columnNames.length == 0 && !this.canHaveEmptyPK) {
            throw new ParseException(String.format("Primary key for table %s.%s cannot be empty.", this.getGrain().getName(), this.getName()));
        }
        for (String n : columnNames) {
            this.validatePKColumn(n);
        }
        this.getGrain().modify();
        this.pk.clear();
        this.pkFinalized = false;
        for (String n : columnNames) {
            this.addPK(n);
        }
        this.finalizePK();
    }

    void addPK(String name) throws ParseException {
        name = this.getGrain().getScore().getIdentifierParser().parse(name);
        if (this.pkFinalized) {
            throw new ParseException(String.format("More than one PRIMARY KEY definition in table '%s'.", this.getName()));
        }
        Column<?> c = this.validatePKColumn(name);
        this.pk.addElement(c);
    }

    private Column<?> validatePKColumn(String name) throws ParseException {
        if ("recversion".equals(name)) {
            throw new ParseException(String.format("Column '%s' is not allowed for primary key.", name));
        }
        Column<?> c = this.columns.get(name);
        if (c == null) {
            throw new ParseException(String.format("Column '%s' is not defined in table '%s'.", name, this.getName()));
        }
        if (c.isNullable()) {
            throw new ParseException(String.format("Column '%s' is nullable and therefore it cannot be a part of a primary key in table '%s'.", name, this.getName()));
        }
        if (c instanceof BinaryColumn) {
            throw new ParseException(String.format("Column %s is of long binary type and therefore it cannot a part of a primary key in table '%s'.", name, this.getName()));
        }
        if (c instanceof StringColumn && ((StringColumn)c).isMax()) {
            throw new ParseException(String.format("Column '%s' is of TEXT type and therefore it cannot a part of a primary key in table '%s'.", name, this.getName()));
        }
        return c;
    }

    final void addFK(ForeignKey fk) throws ParseException {
        if (fk.getParentTable() != this) {
            throw new IllegalArgumentException();
        }
        if (this.fKeys.contains(fk)) {
            StringBuilder sb = new StringBuilder();
            for (Column<?> c : fk.getColumns().values()) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(c.getName());
            }
            throw new ParseException(String.format("Foreign key with columns %s is already defined in table '%s'", sb.toString(), this.getName()));
        }
        this.getGrain().modify();
        this.fKeys.add(fk);
    }

    final synchronized void removeFK(ForeignKey foreignKey) throws ParseException {
        this.getGrain().modify();
        this.fKeys.remove(foreignKey);
    }

    @Override
    public final synchronized void removeColumn(Column<?> column) throws ParseException {
        if (this.pk.contains(column)) {
            throw new ParseException(String.format("Table '%s.%s', field '%s': you cannot drop a column that belongs to a primary key. Change primary key first.", this.getGrain().getName(), this.getName(), column.getName()));
        }
        for (Index ind : this.getGrain().getIndices().values()) {
            if (!ind.getColumns().containsValue(column)) continue;
            throw new ParseException(String.format("Table '%s.%s', field '%s': you cannot drop a column that belongs to an index. Drop or change relevant index first.", this.getGrain().getName(), this.getName(), column.getName()));
        }
        for (ForeignKey fk : this.fKeys) {
            if (!fk.getColumns().containsValue(column)) continue;
            throw new ParseException(String.format("Table '%s.%s', field '%s': you cannot drop a column that belongs to a foreign key. Drop or change relevant foreign key first.", this.getGrain().getName(), this.getName(), column.getName()));
        }
        this.getGrain().modify();
        this.columns.remove(column);
    }

    public void finalizePK() throws ParseException {
        if (this.pk.isEmpty() && !this.canHaveEmptyPK) {
            throw new ParseException(String.format("No primary key defined for table %s!", this.getName()));
        }
        this.pkFinalized = true;
    }

    public Set<ForeignKey> getForeignKeys() {
        return Collections.unmodifiableSet(this.fKeys);
    }

    public Set<Index> getIndices() {
        return Collections.unmodifiableSet(this.indices);
    }

    @Override
    public final String getPkConstraintName() {
        return this.pkConstraintName == null ? BasicTable.limitName("pk_" + this.getName()) : this.pkConstraintName;
    }

    public void setPkConstraintName(String pkConstraintName) throws ParseException {
        if (pkConstraintName != null) {
            pkConstraintName = this.getGrain().getScore().getIdentifierParser().parse(pkConstraintName);
        }
        this.pkConstraintName = pkConstraintName;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    @Override
    public final int getColumnIndex(String name) {
        return this.columns.getIndex(name);
    }

    final void addIndex(Index index) {
        this.indices.add(index);
    }

    final void removeIndex(Index index) {
        this.indices.remove(index);
    }

    public List<String> getImplements() {
        try {
            return CelestaDocUtils.getList(this.getCelestaDoc(), "implements");
        }
        catch (JSONException e1) {
            throw new CelestaException("Error in CelestaDoc for %s.%s: %s", this.getGrain().getName(), this.getName(), e1.getMessage());
        }
    }
}

