/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.curs.celesta.CelestaException;

public final class CelestaDocUtils {
    public static final String OPTION = "option";
    public static final String IMPLEMENTS = "implements";

    private CelestaDocUtils() {
        throw new AssertionError();
    }

    public static String getCelestaDocJSON(String celestaDoc) {
        if (celestaDoc == null) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int state = 0;
        int bracescount = 0;
        block6: for (int i = 0; i < celestaDoc.length(); ++i) {
            char c = celestaDoc.charAt(i);
            switch (state) {
                case 0: {
                    if (c != '{') continue block6;
                    sb.append(c);
                    ++bracescount;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    sb.append(c);
                    if (c == '{') {
                        ++bracescount;
                        continue block6;
                    }
                    if (c == '}') {
                        if (--bracescount != 0) continue block6;
                        return sb.toString();
                    }
                    if (c != '\"') continue block6;
                    state = 2;
                    continue block6;
                }
                case 2: {
                    sb.append(c);
                    if (c == '\\') {
                        state = 3;
                        continue block6;
                    }
                    if (c != '\"') continue block6;
                    state = 1;
                    continue block6;
                }
                case 3: {
                    sb.append(c);
                    state = 2;
                    continue block6;
                }
            }
        }
        if (state != 0) {
            throw new CelestaException("Broken or truncated JSON: %s", sb.toString());
        }
        return "{}";
    }

    public static List<String> getList(String celestaDoc, String key) {
        String json = CelestaDocUtils.getCelestaDocJSON(celestaDoc);
        JSONObject metadata = new JSONObject(json);
        if (metadata.has(key)) {
            JSONArray options = metadata.getJSONArray(key);
            return options.toList().stream().map(String::valueOf).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

