/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableElement;

public final class DateTimeColumn
extends Column<Date> {
    public static final String CELESTA_TYPE = "DATETIME";
    private static final Pattern P = Pattern.compile("'(\\d\\d\\d\\d)([01]\\d)([0123]\\d)'");
    private Date defaultvalue;
    private boolean getdate;

    public DateTimeColumn(TableElement table, String name) throws ParseException {
        super(table, name);
    }

    @Override
    protected void setDefault(String lexvalue) throws ParseException {
        if (lexvalue == null) {
            this.defaultvalue = null;
            this.getdate = false;
        } else if ("GETDATE".equalsIgnoreCase(lexvalue)) {
            this.defaultvalue = null;
            this.getdate = true;
        } else {
            this.defaultvalue = DateTimeColumn.parseISODate(lexvalue);
            this.getdate = false;
        }
    }

    public static Date parseISODate(String lexvalue) throws ParseException {
        Matcher m = P.matcher(lexvalue);
        if (!m.matches()) {
            throw new ParseException(String.format("Invalid datetime value %s. It should match 'YYYYMMDD' pattern.", lexvalue));
        }
        int y = Integer.parseInt(m.group(1));
        int mo = Integer.parseInt(m.group(2));
        int d = Integer.parseInt(m.group(3));
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(y, mo - 1, d);
        return c.getTime();
    }

    @Override
    public Date getDefaultValue() {
        return this.defaultvalue;
    }

    public boolean isGetdate() {
        return this.getdate;
    }

    @Override
    public String jdbcGetterName() {
        return "getTimestamp";
    }

    @Override
    public String getCelestaType() {
        return CELESTA_TYPE;
    }

    @Override
    public Class<?> getJavaClass() {
        return Date.class;
    }

    @Override
    public String getCelestaDefault() {
        if (this.isGetdate()) {
            return "GETDATE()";
        }
        if (this.defaultvalue == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return "'" + df.format(this.defaultvalue) + "'";
    }
}

