/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.List;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.FieldRef;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.TableRef;

final class FieldResolver
extends ExprVisitor {
    private final List<TableRef> tables;

    FieldResolver(List<TableRef> tables) {
        this.tables = tables;
    }

    @Override
    void visitFieldRef(FieldRef fr) throws ParseException {
        if (fr.getColumn() != null) {
            return;
        }
        int foundCounter = 0;
        for (TableRef tRef : this.tables) {
            if (fr.getTableNameOrAlias() != null && fr.getTableNameOrAlias().equals(tRef.getAlias())) {
                fr.setColumn(tRef.getTable().getColumn(fr.getColumnName()));
                ++foundCounter;
                continue;
            }
            if (fr.getTableNameOrAlias() != null || !tRef.getTable().getColumns().containsKey(fr.getColumnName())) continue;
            fr.setColumn(tRef.getTable().getColumn(fr.getColumnName()));
            ++foundCounter;
        }
        if (foundCounter == 0) {
            throw new ParseException(String.format("Cannot resolve field reference '%s'", fr.getCSQL()));
        }
        if (foundCounter > 1) {
            throw new ParseException(String.format("Ambiguous field reference '%s'", fr.getCSQL()));
        }
    }
}

