/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.curs.celesta.DBType;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.DataGrainElement;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.NamedElement;
import ru.curs.celesta.score.NamedElementHolder;
import ru.curs.celesta.score.Namespace;
import ru.curs.celesta.score.NativeSqlElement;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.VersionString;
import ru.curs.celesta.score.View;

public final class Grain
extends NamedElement {
    private static final Pattern NATIVE_SQL = Pattern.compile("--\\{\\{(.*)--}}", 32);
    private final AbstractScore score;
    private VersionString version = VersionString.DEFAULT;
    private int length;
    private int checksum;
    private int dependencyOrder;
    private boolean parsingComplete = false;
    private boolean modified = true;
    private boolean isAutoupdate = true;
    private Set<GrainPart> grainParts = new LinkedHashSet<GrainPart>();
    private Namespace namespace;
    private final Map<Class<? extends GrainElement>, NamedElementHolder<? extends GrainElement>> grainElements = new HashMap<Class<? extends GrainElement>, NamedElementHolder<? extends GrainElement>>();
    private final NamedElementHolder<Index> indices = new NamedElementHolder<Index>(){

        @Override
        protected String getErrorMsg(String name) {
            return String.format("Index '%s' defined more than once in a grain.", name);
        }
    };
    private final Set<String> constraintNames = new HashSet<String>();
    private final Map<DBType, List<NativeSqlElement>> beforeSql = new HashMap<DBType, List<NativeSqlElement>>();
    private final Map<DBType, List<NativeSqlElement>> afterSql = new HashMap<DBType, List<NativeSqlElement>>();

    public Grain(AbstractScore score, String name) throws ParseException {
        super(name, score.getIdentifierParser());
        if (name.indexOf("_") >= 0) {
            throw new ParseException("Invalid grain name '" + name + "'. No underscores are allowed for grain names.");
        }
        this.score = score;
        score.addGrain(this);
    }

    private <T extends GrainElement> NamedElementHolder<T> getElementsHolder(Class<T> cls) {
        return this.grainElements.computeIfAbsent(cls, c -> new NamedElementHolder<T>((Class)c){
            final /* synthetic */ Class val$c;
            {
                this.val$c = clazz;
            }

            @Override
            protected String getErrorMsg(String name) {
                return String.format("%s '%s' defined more than once in a grain.", this.val$c.getSimpleName(), name);
            }
        });
    }

    <T extends GrainElement> void addElement(T element) throws ParseException {
        if (element.getGrain() != this) {
            throw new IllegalArgumentException();
        }
        Optional<String> typeNameOfElementWithSameName = this.grainElements.entrySet().stream().filter(entry -> !((Class)entry.getKey()).equals(element.getClass())).map(entry -> ((NamedElementHolder)entry.getValue()).getElements().entrySet()).flatMap(entrySet -> entrySet.stream()).filter(entry -> ((String)entry.getKey()).equals(element.getName())).findAny().map(entry -> ((GrainElement)entry.getValue()).getClass().getSimpleName());
        if (typeNameOfElementWithSameName.isPresent()) {
            throw new ParseException(String.format("Cannot create grain element '%s', a %s with the same name already exists in grain '%s'.", element.getName(), typeNameOfElementWithSameName.get(), this.getName()));
        }
        this.modify();
        this.getElementsHolder(element.getClass()).addElement(element);
        if (element instanceof BasicTable) {
            this.getElementsHolder(BasicTable.class).addElement((BasicTable)element);
        }
    }

    public <T extends GrainElement> Map<String, T> getElements(Class<T> classOfElement) {
        return this.getElementsHolder(classOfElement).getElements();
    }

    <T extends GrainElement> Collection<T> getElements(Class<T> classOfElement, GrainPart gp) {
        Collection elements = this.getElements(classOfElement).values();
        if (gp != null) {
            elements = elements.stream().filter(t -> gp == t.getGrainPart()).collect(Collectors.toList());
        }
        return elements;
    }

    public Map<String, Index> getIndices() {
        return this.indices.getElements();
    }

    public Map<String, MaterializedView> getMaterializedViews() {
        return this.getElementsHolder(MaterializedView.class).getElements();
    }

    public Map<String, ParameterizedView> getParameterizedViews() {
        return this.getElementsHolder(ParameterizedView.class).getElements();
    }

    public Map<String, BasicTable> getTables() {
        return this.getElementsHolder(BasicTable.class).getElements();
    }

    public <T extends BasicTable> Map<String, T> getTables(Class<T> tableClass) {
        return this.getElementsHolder(tableClass).getElements();
    }

    public Map<String, View> getViews() {
        return this.getElementsHolder(View.class).getElements();
    }

    public <T extends GrainElement> T getElement(String name, Class<T> classOfElement) throws ParseException {
        GrainElement result = (GrainElement)this.getElementsHolder(classOfElement).get(name);
        if (result == null) {
            throw new ParseException(String.format("%s '%s' not found in grain '%s'", classOfElement.getSimpleName(), name, this.getName()));
        }
        return (T)result;
    }

    public void addIndex(Index index) throws ParseException {
        if (index.getGrain() != this) {
            throw new IllegalArgumentException();
        }
        this.modify();
        this.indices.addElement(index);
    }

    synchronized void removeIndex(Index index) throws ParseException {
        this.modify();
        this.indices.remove(index);
        index.getTable().removeIndex(index);
    }

    synchronized <T extends DataGrainElement> void removeElement(T element) throws ParseException {
        if (element instanceof BasicTable) {
            this.removeTable((BasicTable)element);
        } else {
            this.modify();
            this.getElementsHolder(element.getClass()).remove(element);
        }
    }

    private synchronized void removeTable(BasicTable table) throws ParseException {
        this.modify();
        LinkedList<Index> indToDelete = new LinkedList<Index>();
        for (Index ind : this.indices) {
            if (ind.getTable() != table) continue;
            indToDelete.add(ind);
        }
        LinkedList<ForeignKey> fkToDelete = new LinkedList<ForeignKey>();
        for (Grain g : this.score.getGrains().values()) {
            for (BasicTable t : g.getElements(BasicTable.class).values()) {
                for (ForeignKey fk : t.getForeignKeys()) {
                    if (fk.getReferencedTable() != table) continue;
                    fkToDelete.add(fk);
                }
            }
        }
        for (Index ind : indToDelete) {
            ind.delete();
        }
        for (ForeignKey fk : fkToDelete) {
            fk.delete();
        }
        this.getElementsHolder(BasicTable.class).remove(table);
        this.getElementsHolder(table.getClass()).remove(table);
    }

    public AbstractScore getScore() {
        return this.score;
    }

    public boolean isAutoupdate() {
        return this.isAutoupdate;
    }

    public void setAutoupdate(boolean isAutoupdate) {
        this.isAutoupdate = isAutoupdate;
    }

    public VersionString getVersion() {
        return this.version;
    }

    public void setVersion(String version) throws ParseException {
        this.modify();
        this.version = new VersionString(StringColumn.unquoteString(version));
    }

    public int getLength() {
        return this.length;
    }

    void setLength(int length) {
        this.length = length;
    }

    public int getChecksum() {
        return this.checksum;
    }

    void setChecksum(int checksum) {
        this.checksum = checksum;
    }

    void addConstraintName(String name) throws ParseException {
        name = this.getScore().getIdentifierParser().parse(name);
        if (this.constraintNames.contains(name)) {
            throw new ParseException(String.format("Constraint '%s' is defined more than once in a grain.", name));
        }
        this.constraintNames.add(name);
    }

    public boolean isParsingComplete() {
        return this.parsingComplete;
    }

    public int getDependencyOrder() {
        return this.dependencyOrder;
    }

    public void finalizeParsing() throws ParseException {
        for (String tableName : this.getElements(BasicTable.class).keySet()) {
            String sequenceName = tableName + "_seq";
            SequenceElement se = this.getElementsHolder(SequenceElement.class).get(sequenceName);
            if (se == null) continue;
            throw new ParseException(String.format("Identifier %s can't be used for the naming of sequence as it is reserved by Celesta.", sequenceName));
        }
        this.parsingComplete = true;
        this.modified = false;
        this.dependencyOrder = this.score.nextOrderCounter();
    }

    public boolean isModified() {
        return this.modified;
    }

    void modify() throws ParseException {
        if (this.getScore().getSysSchemaName().equals(this.getName()) && this.parsingComplete) {
            throw new ParseException("You cannot modify system grain.");
        }
        this.modified = true;
    }

    public View getView(String name) throws ParseException {
        return this.getElement(name, View.class);
    }

    public MaterializedView getMaterializedView(String name) throws ParseException {
        return this.getElement(name, MaterializedView.class);
    }

    public ParameterizedView getParameterizedView(String name) throws ParseException {
        return this.getElement(name, ParameterizedView.class);
    }

    public BasicTable getTable(String name) throws ParseException {
        return this.getElement(name, BasicTable.class);
    }

    public <T extends BasicTable> T getTable(String name, Class<T> tableClass) throws ParseException {
        return (T)((BasicTable)this.getElement(name, tableClass));
    }

    void addNativeSql(String sql, boolean isBefore, DBType dbType, GrainPart grainPart) throws ParseException {
        Matcher m = NATIVE_SQL.matcher(sql);
        if (!m.matches()) {
            throw new ParseException("Native sql should match pattern --{{...--}}, was " + sql);
        }
        List sqlList = isBefore ? this.beforeSql.computeIfAbsent(dbType, dbTypeVar -> new ArrayList()) : this.afterSql.computeIfAbsent(dbType, dbTypeVar -> new ArrayList());
        sqlList.add(new NativeSqlElement(grainPart, m.group(1)));
    }

    public List<NativeSqlElement> getBeforeSqlList(DBType dbType) {
        return this.beforeSql.getOrDefault((Object)dbType, Collections.emptyList());
    }

    public List<NativeSqlElement> getAfterSqlList(DBType dbType) {
        return this.afterSql.getOrDefault((Object)dbType, Collections.emptyList());
    }

    public Set<GrainPart> getGrainParts() {
        return this.grainParts;
    }

    void addGrainPart(GrainPart grainPart) {
        this.grainParts.add(grainPart);
    }

    public Namespace getNamespace() {
        if (this.namespace != null) {
            return this.namespace;
        }
        if (this.grainParts.isEmpty()) {
            return Namespace.DEFAULT;
        }
        Iterator<GrainPart> i = this.grainParts.iterator();
        Namespace ns = i.next().getNamespace();
        while (i.hasNext()) {
            if (!Namespace.DEFAULT.equals(ns) && ns.equals(i.next().getNamespace())) continue;
            return Namespace.DEFAULT;
        }
        return ns;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }
}

