/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.TableElement;

public final class IntegerColumn
extends Column<Integer> {
    public static final String CELESTA_TYPE = "INT";
    private Integer defaultvalue;
    private SequenceElement sequence;

    public IntegerColumn(TableElement table, String name) throws ParseException {
        super(table, name);
    }

    IntegerColumn(TableElement table) throws ParseException {
        super(table);
    }

    @Override
    protected void setDefault(String lexvalue) throws ParseException {
        if (lexvalue == null) {
            this.defaultvalue = null;
            this.sequence = null;
        } else {
            Pattern p = Pattern.compile("(?i)NEXTVAL\\((.*)\\)");
            Matcher m = p.matcher(lexvalue);
            if (m.matches()) {
                this.defaultvalue = null;
                String sequenceName = this.getParentTable().getGrain().getScore().getIdentifierParser().parse(m.group(1));
                this.sequence = this.getParentTable().getGrain().getElement(sequenceName, SequenceElement.class);
            } else {
                this.defaultvalue = Integer.parseInt(lexvalue);
                this.sequence = null;
            }
        }
    }

    @Override
    public Integer getDefaultValue() {
        return this.defaultvalue;
    }

    public SequenceElement getSequence() {
        return this.sequence;
    }

    @Override
    public String jdbcGetterName() {
        return "getInt";
    }

    @Override
    public String getCelestaType() {
        return CELESTA_TYPE;
    }

    @Override
    public Class<?> getJavaClass() {
        return Integer.class;
    }

    @Override
    public String getCelestaDefault() {
        return this.defaultvalue == null ? null : this.defaultvalue.toString();
    }

    @Override
    public void setCelestaDoc(String celestaDoc) throws ParseException {
        super.setCelestaDoc(celestaDoc);
        try {
            this.getOptions();
        }
        catch (CelestaException e) {
            throw new ParseException(e.getMessage());
        }
    }
}

