/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Map;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.Parameter;
import ru.curs.celesta.score.ParameterRef;
import ru.curs.celesta.score.ParameterResolverResult;
import ru.curs.celesta.score.ParseException;

final class ParameterResolver
extends ExprVisitor {
    private final Map<String, Parameter> parameters;
    private final ParameterResolverResult result;

    ParameterResolver(Map<String, Parameter> parameters) {
        this.parameters = parameters;
        this.result = new ParameterResolverResult();
        this.result.getUnusedParameters().addAll(parameters.keySet());
    }

    @Override
    void visitParameterRef(ParameterRef pr) throws ParseException {
        if (pr.getParameter() != null) {
            return;
        }
        Parameter parameter = this.parameters.get(pr.getName());
        if (parameter == null) {
            throw new ParseException(String.format("Cannot resolve parameter '%s'", pr.getCSQL()));
        }
        pr.setParameter(parameter);
        this.result.getUnusedParameters().remove(parameter.getName());
        this.result.getParametersWithUsageOrder().add(parameter.getName());
    }

    public ParameterResolverResult getResult() {
        return this.result;
    }
}

