/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import ru.curs.celesta.score.AbstractSelectStmt;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.CelestaParser;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.ViewColumnMeta;
import ru.curs.celesta.score.ViewSelectStmt;

public class View
extends AbstractView {
    Map<String, ViewColumnMeta<?>> columnTypes = null;

    View(GrainPart grainPart, String name) throws ParseException {
        super(grainPart, name);
        this.getGrain().addElement(this);
    }

    public View(GrainPart grainPart, String name, String sql) throws ParseException {
        this(grainPart, name);
        try (StringReader sr = new StringReader(sql);){
            CelestaParser parser = new CelestaParser(sr);
            try {
                parser.unionAll(this);
            }
            catch (ParseException e) {
                this.delete();
                throw e;
            }
        }
    }

    @Override
    String viewType() {
        return "view";
    }

    @Override
    AbstractSelectStmt newSelectStatement() {
        return new ViewSelectStmt(this);
    }

    public final Map<String, ViewColumnMeta<?>> getColumns() {
        if (this.getSegments().size() > 0) {
            if (this.columnTypes == null) {
                this.columnTypes = new LinkedHashMap();
                for (Map.Entry<String, Expr> e : this.getSegments().get((int)0).columns.entrySet()) {
                    ViewColumnMeta<?> meta = e.getValue().getMeta();
                    meta.setName(e.getKey());
                    this.columnTypes.put(e.getKey(), meta);
                }
            }
            return this.columnTypes;
        }
        return Collections.emptyMap();
    }

    public void createViewScript(PrintWriter bw, SQLGenerator gen) throws IOException {
        bw.println(gen.preamble(this));
        this.selectScript(bw, gen);
    }
}

