/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.FireBirdColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.StringColumn;

class FireBirdStringColumnDefiner
extends FireBirdColumnDefiner {
    FireBirdStringColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "varchar";
    }

    @Override
    public String getInternalDefinition(Column c) {
        StringColumn ic = (StringColumn)c;
        String fieldType = ic.isMax() ? "blob sub_type text" : String.format("%s(%s)", this.dbFieldType(), ic.getLength());
        return FireBirdStringColumnDefiner.join(c.getQuotedName(), fieldType);
    }

    public String getDefaultDefinition(Column c) {
        StringColumn ic = (StringColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = "default " + StringColumn.quoteString(ic.getDefaultValue());
        }
        return defaultStr;
    }
}

