/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import ru.curs.celesta.dbutils.adaptors.column.MsSqlColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.StringColumn;

class MsSqlStringColumnDefiner
extends MsSqlColumnDefiner {
    MsSqlStringColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "nvarchar";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        String fieldType = String.format("%s(%s)", this.dbFieldType(), ic.isMax() ? "max" : Integer.valueOf(ic.getLength()));
        return MsSqlStringColumnDefiner.join(c.getQuotedName(), fieldType, this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = this.msSQLDefault(c) + StringColumn.quoteString(ic.getDefaultValue());
        }
        return defaultStr;
    }

    @Override
    public String getLightDefaultDefinition(Column<?> c) {
        StringColumn ic = (StringColumn)c;
        String defaultStr = "";
        if (ic.getDefaultValue() != null) {
            defaultStr = "default " + StringColumn.quoteString(ic.getDefaultValue());
        }
        return defaultStr;
    }
}

