/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.column;

import java.text.SimpleDateFormat;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefiner;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;

class PostgresDateTimeColumnDefiner
extends ColumnDefiner {
    PostgresDateTimeColumnDefiner() {
    }

    @Override
    public String dbFieldType() {
        return "timestamp";
    }

    @Override
    public String getMainDefinition(Column<?> c) {
        return PostgresDateTimeColumnDefiner.join(c.getQuotedName(), this.dbFieldType(), this.nullable(c));
    }

    @Override
    public String getDefaultDefinition(Column<?> c) {
        DateTimeColumn ic = (DateTimeColumn)c;
        String defaultStr = "";
        if (ic.isGetdate()) {
            defaultStr = "default now()";
        } else if (ic.getDefaultValue() != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            defaultStr = String.format("default  '%s'", df.format(ic.getDefaultValue()));
        }
        return defaultStr;
    }
}

