/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.ddl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefinerFactory;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.dbutils.meta.DbIndexInfo;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BinaryColumn;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.ForeignKey;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Sum;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.VersionedElement;
import ru.curs.celesta.score.View;
import ru.curs.celesta.score.ZonedDateTimeColumn;

public abstract class DdlGenerator {
    static final Map<String, Class<? extends Column<?>>> CELESTA_TYPES_COLUMN_CLASSES = new HashMap();
    DBAdaptor dmlAdaptor;
    Map<String, Map<String, Set<String>>> triggers = new HashMap<String, Map<String, Set<String>>>();

    public DdlGenerator(DBAdaptor dmlAdaptor) {
        this.dmlAdaptor = dmlAdaptor;
    }

    Optional<String> createSchema(String name) {
        String sql = String.format("create schema \"%s\"", name);
        return Optional.of(sql);
    }

    List<String> createSequence(SequenceElement s) {
        String sql = String.format("CREATE SEQUENCE %s %s", this.sequenceString(s.getGrain().getName(), s.getName()), this.generateArgumentsForCreateSequenceExpression(s, new SequenceElement.Argument[0]));
        return Arrays.asList(sql);
    }

    String dropView(String schemaName, String viewName) {
        String sql = String.format("DROP VIEW %s", this.tableString(schemaName, viewName));
        return sql;
    }

    abstract List<String> dropParameterizedView(String var1, String var2, Connection var3);

    abstract List<String> dropIndex(Grain var1, DbIndexInfo var2);

    final String dropFk(String schemaName, String tableName, String fkName) {
        String sql = String.format("alter table %s drop constraint \"%s\"", this.tableString(schemaName, tableName), fkName);
        return sql;
    }

    List<String> dropUpdateRule(String fkName) {
        return Collections.emptyList();
    }

    final String dropTrigger(TriggerQuery query) {
        this.forgetTrigger(query);
        return this.dropTriggerSql(query);
    }

    abstract String dropTriggerSql(TriggerQuery var1);

    final String tableString(String schemaName, String tableName) {
        return this.dmlAdaptor.tableString(schemaName, tableName);
    }

    final String sequenceString(String schemaName, String sequenceName) {
        return this.dmlAdaptor.sequenceString(schemaName, sequenceName);
    }

    final String pkConstraintString(TableElement tableElement) {
        return this.dmlAdaptor.pkConstraintString(tableElement);
    }

    protected List<String> alterSequence(SequenceElement s) {
        String sql = String.format("ALTER SEQUENCE %s %s", this.sequenceString(s.getGrain().getName(), s.getName()), this.generateArgumentsForCreateSequenceExpression(s, SequenceElement.Argument.START_WITH));
        return Arrays.asList(sql);
    }

    String generateArgumentsForCreateSequenceExpression(SequenceElement s, SequenceElement.Argument ... excludedArguments) {
        return s.getArguments().entrySet().stream().filter(e -> !Arrays.asList(excludedArguments).contains(e.getKey())).map(e -> ((SequenceElement.Argument)((Object)((Object)e.getKey()))).getSql(e.getValue())).collect(Collectors.joining());
    }

    String createTable(TableElement te) {
        VersionedElement ve;
        StringBuilder sb = new StringBuilder();
        sb.append("create table " + this.tableString(te.getGrain().getName(), te.getName()) + "(\n");
        boolean multiple = false;
        for (Column<?> c : te.getColumns().values()) {
            if (multiple) {
                sb.append(",\n");
            }
            sb.append("  " + this.columnDef(c));
            multiple = true;
        }
        if (te instanceof VersionedElement && (ve = (VersionedElement)((Object)te)).isVersioned()) {
            sb.append(",\n").append("  " + this.columnDef(ve.getRecVersionField()));
        }
        if (te.hasPrimeKey()) {
            sb.append(",\n");
            sb.append(String.format("  constraint \"%s\" primary key (", this.pkConstraintString(te)));
            multiple = false;
            for (String s : te.getPrimaryKey().keySet()) {
                if (multiple) {
                    sb.append(", ");
                }
                sb.append('\"');
                sb.append(s);
                sb.append('\"');
                multiple = true;
            }
            sb.append(")");
        }
        sb.append("\n)");
        return sb.toString();
    }

    public abstract String dropPk(TableElement var1, String var2);

    final String columnDef(Column<?> c) {
        Class<?> cClass = c.getClass();
        return ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass).getFullDefinition(c);
    }

    final String createColumn(Column<?> c) {
        String sql = String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " add %s", this.columnDef(c));
        return sql;
    }

    abstract DBType getType();

    abstract List<String> updateVersioningTrigger(Connection var1, TableElement var2);

    abstract List<String> createIndex(Index var1);

    abstract List<String> updateColumn(Connection var1, Column<?> var2, DbColumnInfo var3);

    final String createPk(TableElement t) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("alter table %s add constraint \"%s\"  primary key (", this.tableString(t.getGrain().getName(), t.getName()), this.pkConstraintString(t)));
        boolean multiple = false;
        for (String s : t.getPrimaryKey().keySet()) {
            if (multiple) {
                sb.append(", ");
            }
            sb.append('\"');
            sb.append(s);
            sb.append('\"');
            multiple = true;
        }
        sb.append(")");
        return sb.toString();
    }

    final List<String> createFk(Connection conn, ForeignKey fk) {
        LinkedList<StringBuilder> sqlQueue = new LinkedList<StringBuilder>();
        StringBuilder sql = new StringBuilder();
        sql.append("alter table ");
        sql.append(this.tableString(fk.getParentTable().getGrain().getName(), fk.getParentTable().getName()));
        sql.append(" add constraint \"");
        sql.append(fk.getConstraintName());
        sql.append("\" foreign key (");
        boolean needComma = false;
        for (String name : fk.getColumns().keySet()) {
            if (needComma) {
                sql.append(", ");
            }
            sql.append('\"');
            sql.append(name);
            sql.append('\"');
            needComma = true;
        }
        sql.append(") references ");
        sql.append(this.tableString(fk.getReferencedTable().getGrain().getName(), fk.getReferencedTable().getName()));
        sql.append("(");
        needComma = false;
        for (String name : fk.getReferencedTable().getPrimaryKey().keySet()) {
            if (needComma) {
                sql.append(", ");
            }
            sql.append('\"');
            sql.append(name);
            sql.append('\"');
            needComma = true;
        }
        sql.append(")");
        switch (fk.getDeleteRule()) {
            case SET_NULL: {
                sql.append(" on delete set null");
                break;
            }
            case CASCADE: {
                sql.append(" on delete cascade");
                break;
            }
        }
        sqlQueue.add(sql);
        this.processCreateUpdateRule(conn, fk, sqlQueue);
        return sqlQueue.stream().map(StringBuilder::toString).collect(Collectors.toList());
    }

    void processCreateUpdateRule(Connection conn, ForeignKey fk, LinkedList<StringBuilder> sqlQueue) {
        StringBuilder sql = sqlQueue.peek();
        switch (fk.getUpdateRule()) {
            case SET_NULL: {
                sql.append(" on update set null");
                break;
            }
            case CASCADE: {
                sql.append(" on update cascade");
                break;
            }
        }
    }

    final String createView(View v) {
        try {
            SQLGenerator gen = this.getViewSQLGenerator();
            StringWriter sw = new StringWriter();
            PrintWriter bw = new PrintWriter(sw);
            v.createViewScript(bw, gen);
            bw.flush();
            String sql = sw.toString();
            return sql;
        }
        catch (IOException e) {
            throw new CelestaException(e);
        }
    }

    List<String> afterCreateTable(Connection conn, TableElement t) {
        return Collections.emptyList();
    }

    final String dropTable(TableElement t) {
        String sql = String.format("DROP TABLE %s", this.tableString(t.getGrain().getName(), t.getName()));
        this.triggers.computeIfAbsent(t.getGrain().getName(), s -> new HashMap()).remove(t.getName());
        return sql;
    }

    final List<String> initDataForMaterializedView(MaterializedView mv) {
        TableElement t = mv.getRefTable().getTable();
        String mvIdentifier = this.tableString(mv.getGrain().getName(), mv.getName());
        String mvColumns = mv.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> "\"" + alias + "\"").collect(Collectors.joining(", ")).concat(", \"").concat("surrogate_count").concat("\"");
        String tableGroupByColumns = mv.getColumns().values().stream().filter(v -> mv.isGroupByColumn(v.getName())).map(v -> {
            Column<?> colRef = mv.getColumnRef(v.getName());
            String groupByColStr = "\"" + mv.getColumnRef(v.getName()).getName() + "\"";
            if ("DATETIME".equals(colRef.getCelestaType())) {
                return this.truncDate(groupByColStr);
            }
            return groupByColStr;
        }).collect(Collectors.joining(", "));
        String deleteSql = this.truncateTable(mvIdentifier);
        String colsToSelect = mv.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> {
            Column<?> colRef = mv.getColumnRef((String)alias);
            Map<String, Expr> aggrCols = mv.getAggregateColumns();
            if (aggrCols.containsKey(alias)) {
                Expr agrExpr = aggrCols.get(alias);
                if (agrExpr instanceof Count) {
                    return "COUNT(*)";
                }
                if (agrExpr instanceof Sum) {
                    return "SUM(\"" + colRef.getName() + "\")";
                }
                throw new RuntimeException(String.format("Aggregate func of type %s is not supported", agrExpr.getClass().getSimpleName()));
            }
            if ("DATETIME".equals(colRef.getCelestaType())) {
                return this.truncDate("\"" + colRef.getName() + "\"");
            }
            return "\"" + colRef.getName() + "\"";
        }).collect(Collectors.joining(", "));
        String selectScript = String.format("SELECT " + colsToSelect + ", COUNT(*) FROM " + this.tableString(t.getGrain().getName(), t.getName()) + " GROUP BY %s", tableGroupByColumns);
        String insertSql = String.format("INSERT INTO %s (%s) " + selectScript, mvIdentifier, mvColumns);
        return Arrays.asList(deleteSql, insertSql);
    }

    String truncateTable(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    final boolean triggerExists(Connection conn, TriggerQuery query) {
        try {
            return this.isTriggerKnown(query) || this.dmlAdaptor.triggerExists(conn, query);
        }
        catch (SQLException e) {
            throw new CelestaException(e);
        }
    }

    final void rememberTrigger(TriggerQuery query) {
        this.triggers.computeIfAbsent(query.getSchema(), s -> new HashMap()).computeIfAbsent(query.getTableName(), t -> new HashSet()).add(query.getName());
    }

    final void forgetTrigger(TriggerQuery query) {
        this.triggers.computeIfAbsent(query.getSchema(), s -> new HashMap()).computeIfAbsent(query.getTableName(), t -> new HashSet()).remove(query.getName());
    }

    final boolean isTriggerKnown(TriggerQuery query) {
        return this.triggers.computeIfAbsent(query.getSchema(), s -> new HashMap()).computeIfAbsent(query.getTableName(), t -> new HashSet()).contains(query.getName());
    }

    abstract SQLGenerator getViewSQLGenerator();

    abstract List<String> createParameterizedView(ParameterizedView var1);

    abstract Optional<String> dropAutoIncrement(Connection var1, TableElement var2);

    public abstract List<String> dropTableTriggersForMaterializedViews(Connection var1, BasicTable var2);

    public abstract List<String> createTableTriggersForMaterializedViews(BasicTable var1);

    abstract String truncDate(String var1);

    static {
        CELESTA_TYPES_COLUMN_CLASSES.put("INT", IntegerColumn.class);
        CELESTA_TYPES_COLUMN_CLASSES.put("REAL", FloatingColumn.class);
        CELESTA_TYPES_COLUMN_CLASSES.put("DECIMAL", DecimalColumn.class);
        CELESTA_TYPES_COLUMN_CLASSES.put("BIT", BooleanColumn.class);
        CELESTA_TYPES_COLUMN_CLASSES.put("VARCHAR", StringColumn.class);
        CELESTA_TYPES_COLUMN_CLASSES.put("BLOB", BinaryColumn.class);
        CELESTA_TYPES_COLUMN_CLASSES.put("DATETIME", DateTimeColumn.class);
        CELESTA_TYPES_COLUMN_CLASSES.put("DATETIME WITH TIME ZONE", ZonedDateTimeColumn.class);
    }
}

