/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.adaptors.ddl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.DBType;
import ru.curs.celesta.dbutils.adaptors.DBAdaptor;
import ru.curs.celesta.dbutils.adaptors.column.ColumnDefinerFactory;
import ru.curs.celesta.dbutils.adaptors.ddl.OpenSourceDdlGenerator;
import ru.curs.celesta.dbutils.jdbc.SqlUtils;
import ru.curs.celesta.dbutils.meta.DbColumnInfo;
import ru.curs.celesta.event.TriggerQuery;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.Parameter;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.SQLGenerator;
import ru.curs.celesta.score.StringColumn;
import ru.curs.celesta.score.Sum;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.VersionedElement;
import ru.curs.celesta.score.ViewColumnMeta;
import ru.curs.celesta.score.ViewColumnType;

public final class PostgresDdlGenerator
extends OpenSourceDdlGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresDdlGenerator.class);

    public PostgresDdlGenerator(DBAdaptor dmlAdaptor) {
        super(dmlAdaptor);
    }

    @Override
    List<String> dropParameterizedView(String schemaName, String viewName, Connection conn) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "SELECT format('DROP FUNCTION IF EXISTS %s(%s);',\n  p.oid::regproc, pg_get_function_identity_arguments(p.oid))\n FROM pg_catalog.pg_proc p\n LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace\n WHERE\n p.oid::regproc::text = '" + String.format("%s.%s", schemaName, viewName) + "';";
        try (ResultSet rs = SqlUtils.executeQuery(conn, sql);){
            if (rs.next()) {
                String dropSql = rs.getString(1);
                result.add(dropSql);
            }
        }
        catch (SQLException e) {
            throw new CelestaException(e);
        }
        return result;
    }

    @Override
    DBType getType() {
        return DBType.POSTGRESQL;
    }

    @Override
    List<String> updateVersioningTrigger(Connection conn, TableElement t) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withName("versioncheck").withTableName(t.getName());
            boolean triggerExists = this.triggerExists(conn, query);
            if (t instanceof VersionedElement) {
                VersionedElement ve = (VersionedElement)((Object)t);
                if (ve.isVersioned()) {
                    if (!triggerExists) {
                        String sql = "CREATE TRIGGER \"versioncheck\" BEFORE UPDATE ON " + this.tableString(t.getGrain().getName(), t.getName()) + " FOR EACH ROW EXECUTE PROCEDURE " + t.getGrain().getScore().getSysSchemaName() + ".recversion_check();";
                        result.add(sql);
                        this.rememberTrigger(query);
                    }
                } else if (triggerExists) {
                    result.add(this.dropTrigger(query));
                }
            }
        }
        catch (CelestaException e) {
            throw new CelestaException("Could not update version check trigger on %s.%s: %s", t.getGrain().getName(), t.getName(), e.getMessage());
        }
        return result;
    }

    @Override
    public String dropPk(TableElement t, String pkName) {
        String sql = String.format("alter table %s.%s drop constraint \"%s\" cascade", t.getGrain().getQuotedName(), t.getQuotedName(), pkName);
        return sql;
    }

    @Override
    void updateColType(Column<?> c, DbColumnInfo actual, List<String> sqlList) {
        DecimalColumn dc;
        String colType;
        Class<?> cClass = c.getClass();
        if (c.getClass() == StringColumn.class) {
            StringColumn sc = (StringColumn)c;
            colType = sc.isMax() ? "text" : String.format("%s(%s)", ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass).dbFieldType(), sc.getLength());
        } else if (c.getClass() == DecimalColumn.class) {
            DecimalColumn dc2 = (DecimalColumn)c;
            colType = String.format("%s(%s,%s)", ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass).dbFieldType(), dc2.getPrecision(), dc2.getScale());
        } else {
            colType = ColumnDefinerFactory.getColumnDefiner(this.getType(), cClass).dbFieldType();
        }
        StringBuilder alterSql = new StringBuilder(String.format("alter table " + this.tableString(c.getParentTable().getGrain().getName(), c.getParentTable().getName()) + " ALTER COLUMN \"%s\" TYPE %s", c.getName(), colType));
        if (c.getClass() != actual.getType()) {
            if (c.getClass() == IntegerColumn.class) {
                alterSql.append(String.format(" USING (%s::integer);", c.getQuotedName()));
            } else if (c.getClass() == BooleanColumn.class) {
                alterSql.append(String.format(" USING (%s::boolean);", c.getQuotedName()));
            }
            sqlList.add(alterSql.toString());
        } else if (c.getClass() == StringColumn.class) {
            StringColumn sc = (StringColumn)c;
            if (sc.isMax() != actual.isMax() || sc.getLength() != actual.getLength()) {
                sqlList.add(alterSql.toString());
            }
        } else if (c.getClass() == DecimalColumn.class && ((dc = (DecimalColumn)c).getPrecision() != actual.getLength() || dc.getScale() != dc.getScale())) {
            sqlList.add(alterSql.toString());
        }
    }

    @Override
    List<String> createIndex(Index index) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        boolean conjugate = false;
        for (Map.Entry<String, Column<?>> c : index.getColumns().entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
                sb2.append(", ");
            }
            sb.append('\"');
            sb2.append('\"');
            sb.append(c.getKey());
            sb2.append(c.getKey());
            sb.append('\"');
            sb2.append('\"');
            if (!(c.getValue() instanceof StringColumn) || ((StringColumn)c.getValue()).isMax()) continue;
            sb2.append(" varchar_pattern_ops");
            conjugate = true;
        }
        String sql = String.format("CREATE INDEX \"%s\" ON " + this.tableString(index.getTable().getGrain().getName(), index.getTable().getName()) + " (%s)", index.getName(), sb.toString());
        result.add(sql);
        if (conjugate) {
            sql = String.format("CREATE INDEX \"%s\" ON " + this.tableString(index.getTable().getGrain().getName(), index.getTable().getName()) + " (%s)", index.getName() + "__vpo", sb2.toString());
            result.add(sql);
        }
        return result;
    }

    @Override
    public SQLGenerator getViewSQLGenerator() {
        return new SQLGenerator(){

            @Override
            protected String paramLiteral(String paramName) {
                return paramName;
            }

            @Override
            protected String getDate() {
                return "CURRENT_TIMESTAMP";
            }
        };
    }

    @Override
    List<String> createParameterizedView(ParameterizedView pv) {
        SQLGenerator gen = this.getViewSQLGenerator();
        StringWriter sw = new StringWriter();
        PrintWriter bw = new PrintWriter(sw);
        try {
            pv.selectScript(bw, gen);
        }
        catch (IOException e2) {
            throw new CelestaException(e2);
        }
        bw.flush();
        String pvParams = pv.getParameters().entrySet().stream().map(e -> (String)e.getKey() + " " + ColumnDefinerFactory.getColumnDefiner(this.getType(), (Class)CELESTA_TYPES_COLUMN_CLASSES.get(((Parameter)e.getValue()).getType().getCelestaType())).dbFieldType()).collect(Collectors.joining(", "));
        String pViewCols = pv.getColumns().entrySet().stream().map(e -> {
            StringBuilder sb = new StringBuilder("\"").append((String)e.getKey()).append("\" ");
            if (pv.getAggregateColumns().containsKey(e.getKey()) && ((ViewColumnMeta)e.getValue()).getColumnType() != ViewColumnType.DECIMAL && ((ViewColumnMeta)e.getValue()).getColumnType() != ViewColumnType.REAL) {
                sb.append("bigint");
            } else {
                sb.append(ColumnDefinerFactory.getColumnDefiner(this.getType(), (Class)CELESTA_TYPES_COLUMN_CLASSES.get(((ViewColumnMeta)e.getValue()).getCelestaType())).dbFieldType());
            }
            return sb.toString();
        }).collect(Collectors.joining(", "));
        String selectSql = sw.toString();
        String sql = String.format("create or replace function " + this.tableString(pv.getGrain().getName(), pv.getName()) + "(%s) returns TABLE(%s) AS\n$$\n %s $$\nlanguage sql;", pvParams, pViewCols, selectSql);
        return Collections.singletonList(sql);
    }

    @Override
    String truncDate(String dateStr) {
        return "date_trunc('DAY'," + dateStr + ")";
    }

    @Override
    public List<String> dropTableTriggersForMaterializedViews(Connection conn, BasicTable t) {
        ArrayList<String> result = new ArrayList<String>();
        List mvList = t.getGrain().getElements(MaterializedView.class).values().stream().filter(mv -> mv.getRefTable().getTable().equals(t)).collect(Collectors.toList());
        for (MaterializedView mv2 : mvList) {
            TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName());
            String insertTriggerName = mv2.getTriggerName(TriggerType.POST_INSERT);
            String updateTriggerName = mv2.getTriggerName(TriggerType.POST_UPDATE);
            String deleteTriggerName = mv2.getTriggerName(TriggerType.POST_DELETE);
            String insertTriggerFunctionFullName = String.format("\"%s\".\"%s_insertTriggerFunc\"()", t.getGrain().getName(), mv2.getName());
            String updateTriggerFunctionFullName = String.format("\"%s\".\"%s_updateTriggerFunc\"()", t.getGrain().getName(), mv2.getName());
            String deleteTriggerFunctionFullName = String.format("\"%s\".\"%s_deleteTriggerFunc\"()", t.getGrain().getName(), mv2.getName());
            query.withName(insertTriggerName);
            if (this.triggerExists(conn, query)) {
                result.add(this.dropTrigger(query));
            }
            query.withName(updateTriggerName);
            if (this.triggerExists(conn, query)) {
                result.add(this.dropTrigger(query));
            }
            query.withName(deleteTriggerName);
            if (this.triggerExists(conn, query)) {
                result.add(this.dropTrigger(query));
            }
            String sqlTemplate = "DROP FUNCTION IF EXISTS %s";
            String sql = String.format(sqlTemplate, insertTriggerFunctionFullName);
            result.add(sql);
            sql = String.format(sqlTemplate, updateTriggerFunctionFullName);
            result.add(sql);
            sql = String.format(sqlTemplate, deleteTriggerFunctionFullName);
            result.add(sql);
        }
        return result;
    }

    @Override
    public List<String> createTableTriggersForMaterializedViews(BasicTable t) {
        ArrayList<String> result = new ArrayList<String>();
        List mvList = t.getGrain().getElements(MaterializedView.class).values().stream().filter(mv -> mv.getRefTable().getTable().equals(t)).collect(Collectors.toList());
        String fullTableName = this.tableString(t.getGrain().getName(), t.getName());
        TriggerQuery query = new TriggerQuery().withSchema(t.getGrain().getName()).withTableName(t.getName());
        for (MaterializedView mv2 : mvList) {
            String fullMvName = this.tableString(mv2.getGrain().getName(), mv2.getName());
            String insertTriggerName = mv2.getTriggerName(TriggerType.POST_INSERT);
            String updateTriggerName = mv2.getTriggerName(TriggerType.POST_UPDATE);
            String deleteTriggerName = mv2.getTriggerName(TriggerType.POST_DELETE);
            String insertTriggerFunctionFullName = String.format("\"%s\".\"%s_insertTriggerFunc\"()", t.getGrain().getName(), mv2.getName());
            String updateTriggerFunctionFullName = String.format("\"%s\".\"%s_updateTriggerFunc\"()", t.getGrain().getName(), mv2.getName());
            String deleteTriggerFunctionFullName = String.format("\"%s\".\"%s_deleteTriggerFunc\"()", t.getGrain().getName(), mv2.getName());
            String mvColumns = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).collect(Collectors.joining(", "));
            String whereCondition = mv2.getColumns().keySet().stream().filter(mv2::isGroupByColumn).map(alias -> alias + " = $1." + alias + " ").collect(Collectors.joining(" AND "));
            StringBuilder selectStmtBuilder = new StringBuilder(mv2.getSelectPartOfScript()).append(" FROM ").append(fullTableName).append(" ");
            selectStmtBuilder.append(" WHERE ").append(whereCondition).append(mv2.getGroupByPartOfScript());
            String setStatementTemplate = mv2.getAggregateColumns().entrySet().stream().map(e -> {
                StringBuilder sb = new StringBuilder();
                String alias = (String)e.getKey();
                sb.append("\"").append(alias.replace("\"", "")).append("\" = \"").append(alias.replace("\"", "")).append("\" %1$s ");
                if (e.getValue() instanceof Sum) {
                    sb.append("%2$s.\"").append(mv2.getColumnRef(alias.replace("\"", "")).getName()).append("\"");
                } else if (e.getValue() instanceof Count) {
                    sb.append("1");
                }
                return sb.toString();
            }).collect(Collectors.joining(", ")).concat(", \"").concat("surrogate_count").concat("\" = ").concat("\"").concat("surrogate_count").concat("\" %1$s 1");
            String rowConditionTemplate = mv2.getColumns().keySet().stream().filter(mv2::isGroupByColumn).map(alias -> {
                Column<?> colRef = mv2.getColumnRef((String)alias);
                if ("DATETIME".equals(colRef.getCelestaType())) {
                    return "\"" + alias + "\" = date_trunc('DAY', %1$s.\"" + colRef.getName() + "\")";
                }
                return "\"" + alias + "\" = %1$s.\"" + colRef.getName() + "\"";
            }).collect(Collectors.joining(" AND "));
            String rowColumnsTemplate = mv2.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> {
                Map<String, Expr> aggrCols = mv2.getAggregateColumns();
                if (aggrCols.containsKey(alias) && aggrCols.get(alias) instanceof Count) {
                    return "1";
                }
                Column<?> colRef = mv2.getColumnRef((String)alias);
                if ("DATETIME".equals(colRef.getCelestaType())) {
                    return "date_trunc('DAY', %1$s.\"" + mv2.getColumnRef((String)alias) + "\")";
                }
                return "%1$s.\"" + mv2.getColumnRef((String)alias) + "\"";
            }).collect(Collectors.joining(", "));
            String whereForDelete = String.format(rowConditionTemplate, "OLD") + " AND \"" + "surrogate_count" + "\" = 0 ";
            String insertSql = String.format("UPDATE %s SET %s WHERE %s ;\nGET DIAGNOSTICS updatedCount = ROW_COUNT; \nIF updatedCount = 0 THEN \n INSERT INTO %s (%s) VALUES(%s); \nEND IF;\n", fullMvName, String.format(setStatementTemplate, "+", "NEW"), String.format(rowConditionTemplate, "NEW"), fullMvName, mvColumns + ", " + "surrogate_count", String.format(rowColumnsTemplate, "NEW") + ", 1");
            String deleteSql = String.format("UPDATE %s SET %s WHERE %s ;\nDELETE FROM %s WHERE %s ;\n", fullMvName, String.format(setStatementTemplate, "-", "OLD"), String.format(rowConditionTemplate, "OLD"), fullMvName, whereForDelete);
            String sql = String.format("CREATE OR REPLACE FUNCTION %s RETURNS trigger AS $BODY$ \n DECLARE\nupdatedCount int;\nBEGIN \n/*CHECKSUM%sCHECKSUM*/\nLOCK TABLE ONLY %s IN EXCLUSIVE MODE; \n%s RETURN NEW; END; $BODY$\n  LANGUAGE plpgsql VOLATILE COST 100;", insertTriggerFunctionFullName, mv2.getChecksum(), fullMvName, insertSql);
            LOGGER.trace(sql);
            result.add(sql);
            sql = String.format("CREATE TRIGGER \"%s\" AFTER INSERT ON %s FOR EACH ROW EXECUTE PROCEDURE %s", insertTriggerName, fullTableName, insertTriggerFunctionFullName);
            LOGGER.trace(sql);
            result.add(sql);
            this.rememberTrigger(query.withName(insertTriggerName));
            sql = String.format("CREATE OR REPLACE FUNCTION %s RETURNS trigger AS $BODY$ \n DECLARE\nupdatedCount int;\nBEGIN \nLOCK TABLE ONLY %s IN EXCLUSIVE MODE; \n%s %s RETURN NEW; END; $BODY$\n  LANGUAGE plpgsql VOLATILE COST 100;", updateTriggerFunctionFullName, fullMvName, deleteSql, insertSql);
            LOGGER.trace(sql);
            result.add(sql);
            sql = String.format("CREATE TRIGGER \"%s\" AFTER UPDATE ON %s FOR EACH ROW EXECUTE PROCEDURE %s", updateTriggerName, fullTableName, updateTriggerFunctionFullName);
            LOGGER.trace(sql);
            result.add(sql);
            this.rememberTrigger(query.withName(updateTriggerName));
            sql = String.format("CREATE OR REPLACE FUNCTION %s RETURNS trigger AS $BODY$ \n BEGIN \nLOCK TABLE ONLY %s IN EXCLUSIVE MODE; \n%sRETURN OLD; END; $BODY$\n  LANGUAGE plpgsql VOLATILE COST 100;", deleteTriggerFunctionFullName, fullMvName, deleteSql);
            LOGGER.trace(sql);
            result.add(sql);
            sql = String.format("CREATE TRIGGER \"%s\" AFTER DELETE ON %s FOR EACH ROW EXECUTE PROCEDURE %s", deleteTriggerName, fullTableName, deleteTriggerFunctionFullName);
            LOGGER.trace(sql);
            result.add(sql);
            this.rememberTrigger(query.withName(deleteTriggerName));
        }
        return result;
    }
}

