/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.h2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.h2.api.Trigger;
import ru.curs.celesta.CurrentScore;
import ru.curs.celesta.event.TriggerType;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.Sum;

public abstract class AbstractMaterializeViewTrigger
implements Trigger {
    private static final Map<Integer, TriggerType> TRIGGER_TYPE_MAP = new HashMap<Integer, TriggerType>();
    private BasicTable t;
    private MaterializedView mv;
    private String tFullName;
    private String mvFullName;
    private String keySearchTerm;
    private String mvAllColumns;
    private HashMap<Integer, String> tGroupByColumnIndices = new LinkedHashMap<Integer, String>();
    private HashMap<Integer, String> mvColumnRefs = new LinkedHashMap<Integer, String>();

    public void init(Connection connection, String schemaName, String triggerName, String tableName, boolean before, int type) {
        try {
            AbstractScore score = CurrentScore.get();
            Map<String, Grain> grains = score.getGrains();
            Grain g = grains.get(schemaName);
            this.t = g.getElement(tableName, BasicTable.class);
            this.mv = g.getElements(MaterializedView.class).values().stream().filter(mv -> triggerName.equals(mv.getTriggerName(TRIGGER_TYPE_MAP.get(type)))).findFirst().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tFullName = String.format("\"%s\".\"%s\"", this.t.getGrain().getName(), this.t.getName());
        this.mvFullName = String.format("\"%s\".\"%s\"", this.mv.getGrain().getName(), this.mv.getName());
        this.mvAllColumns = this.mv.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(v -> "\"" + v + "\"").collect(Collectors.joining(", "));
        ArrayList<String> keySearchTerms = new ArrayList<String>();
        List<String> columnRefNames = this.mv.getColumnRefNames();
        int curIndex = 0;
        for (String tCol : this.t.getColumns().keySet()) {
            for (Map.Entry<String, Column<?>> col : this.mv.getColumns().entrySet()) {
                if (!this.mv.isGroupByColumn(col.getKey()) || !tCol.equals(this.mv.getColumnRef(col.getKey()).getName())) continue;
                this.tGroupByColumnIndices.put(curIndex, tCol);
                keySearchTerms.add(String.format("(\"%s\" = %s)", col.getKey(), "DATETIME".equals(col.getValue().getCelestaType()) ? "TRUNC(?)" : "?"));
                break;
            }
            if (columnRefNames.contains(tCol)) {
                this.mvColumnRefs.put(curIndex, tCol);
            }
            ++curIndex;
        }
        this.keySearchTerm = String.join((CharSequence)" and ", keySearchTerms);
    }

    void delete(Connection conn, Object[] row) throws SQLException {
        HashMap<String, Object> groupByColumnValues = this.getTableRowGroupByColumns(row);
        String deleteSql = String.format("DELETE FROM %s WHERE %s", this.mvFullName, this.keySearchTerm);
        this.setParamsAndRun(conn, groupByColumnValues, deleteSql);
    }

    void insert(Connection conn, Object[] row) throws SQLException {
        HashMap<String, Object> groupByColumnValues = this.getTableRowGroupByColumns(row);
        String whereCondition = groupByColumnValues.keySet().stream().map(alias -> {
            try {
                return "DATETIME".equals(this.t.getColumn((String)alias).getCelestaType()) ? "TRUNC(\"" + alias + "\") = TRUNC(?)" : "\"" + alias + "\" = ?";
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining(" AND "));
        String selectPartOfScript = this.mv.getColumns().keySet().stream().filter(alias -> !"surrogate_count".equals(alias)).map(alias -> {
            Column<?> colRef = this.mv.getColumnRef((String)alias);
            Map<String, Expr> aggrCols = this.mv.getAggregateColumns();
            if (aggrCols.containsKey(alias)) {
                if (colRef == null) {
                    if (aggrCols.get(alias) instanceof Count) {
                        return "COUNT(*) as \"" + alias + "\"";
                    }
                    return "";
                }
                if (aggrCols.get(alias) instanceof Sum) {
                    return "SUM(\"" + colRef.getName() + "\") as \"" + alias + "\"";
                }
                return "";
            }
            if ("DATETIME".equals(colRef.getCelestaType())) {
                return "TRUNC(\"" + colRef.getName() + "\") as \"" + alias + "\"";
            }
            return "\"" + colRef.getName() + "\" as \"" + alias + "\"";
        }).filter(str -> !str.isEmpty()).collect(Collectors.joining(", ")).concat(", COUNT(*) AS surrogate_count");
        StringBuilder selectStmtBuilder = new StringBuilder("SELECT ").append(selectPartOfScript).append(" FROM ").append(this.tFullName).append(" ");
        selectStmtBuilder.append(" WHERE ").append(whereCondition).append(this.mv.getGroupByPartOfScript());
        String insertSql = String.format("INSERT INTO %s (%s) %s", this.mvFullName, this.mvAllColumns + ", \"" + "surrogate_count" + "\"", selectStmtBuilder.toString());
        this.setParamsAndRun(conn, groupByColumnValues, insertSql);
    }

    private void setParamsAndRun(Connection conn, HashMap<String, Object> groupByColumnValues, String insertSql) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(insertSql);){
            int i = 0;
            for (Object value : groupByColumnValues.values()) {
                stmt.setObject(++i, value);
            }
            stmt.execute();
        }
    }

    public void close() {
    }

    public void remove() {
    }

    abstract String getNamePrefix();

    private HashMap<String, Object> getTableRowGroupByColumns(Object[] row) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.tGroupByColumnIndices.entrySet().stream().forEach(e -> result.put((String)e.getValue(), row[(Integer)e.getKey()]));
        return result;
    }

    HashMap<Integer, String> getMvColumnRefs() {
        return this.mvColumnRefs;
    }

    static {
        TRIGGER_TYPE_MAP.put(1, TriggerType.POST_INSERT);
        TRIGGER_TYPE_MAP.put(2, TriggerType.POST_UPDATE);
        TRIGGER_TYPE_MAP.put(4, TriggerType.POST_DELETE);
    }
}

