/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.dbutils.meta;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.curs.celesta.score.BooleanColumn;
import ru.curs.celesta.score.Column;
import ru.curs.celesta.score.DateTimeColumn;
import ru.curs.celesta.score.DecimalColumn;
import ru.curs.celesta.score.FloatingColumn;
import ru.curs.celesta.score.IntegerColumn;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.StringColumn;

public final class DbColumnInfo {
    public static final String SEQUENCE_NEXT_VAL_PATTERN = "(?i)NEXTVAL\\((.*)\\)";
    private String name;
    private Class<? extends Column<?>> type;
    private boolean isNullable;
    private String defaultValue = "";
    private int length;
    private int scale;
    private boolean isMax;

    public String getName() {
        return this.name;
    }

    public Class<? extends Column<?>> getType() {
        return this.type;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isMax() {
        return this.isMax;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Class<? extends Column<?>> type) {
        this.type = type;
    }

    public void setNullable(boolean isNullable) {
        this.isNullable = isNullable;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setMax(boolean isMax) {
        this.isMax = isMax;
    }

    public boolean reflects(Column<?> value) {
        DecimalColumn dc;
        if (value.getClass() != this.type) {
            return false;
        }
        if (!(this.type == StringColumn.class && "''".equals(this.defaultValue) || value.isNullable() == this.isNullable)) {
            return false;
        }
        if (this.type == StringColumn.class) {
            StringColumn col = (StringColumn)value;
            if (!(!this.isMax ? this.length == col.getLength() : col.isMax())) {
                return false;
            }
        }
        if (this.type == DecimalColumn.class && ((dc = (DecimalColumn)value).getPrecision() != this.length || dc.getScale() != this.scale)) {
            return false;
        }
        if (this.defaultValue.isEmpty()) {
            if (this.type == DateTimeColumn.class) {
                DateTimeColumn dtc = (DateTimeColumn)value;
                return dtc.getDefaultValue() == null && !dtc.isGetdate();
            }
            if (this.type == IntegerColumn.class) {
                IntegerColumn ic = (IntegerColumn)value;
                return ic.getDefaultValue() == null && ic.getSequence() == null;
            }
            return value.getDefaultValue() == null;
        }
        return this.checkDefault(value);
    }

    private boolean checkDefault(Column<?> value) {
        boolean result;
        if (this.type == BooleanColumn.class) {
            try {
                result = BooleanColumn.parseSQLBool(this.defaultValue).equals(value.getDefaultValue());
            }
            catch (ParseException e) {
                result = false;
            }
        } else if (this.type == IntegerColumn.class) {
            Pattern p = Pattern.compile(SEQUENCE_NEXT_VAL_PATTERN);
            IntegerColumn iValue = (IntegerColumn)value;
            if (iValue.getSequence() != null) {
                Matcher m = p.matcher(this.defaultValue);
                result = m.matches();
                if (result) {
                    String sequenceName = m.group(1);
                    result = sequenceName.equals(iValue.getSequence().getName());
                }
            } else {
                result = !p.matcher(this.defaultValue).matches() ? Integer.valueOf(this.defaultValue).equals(value.getDefaultValue()) : false;
            }
        } else if (this.type == FloatingColumn.class) {
            result = Double.valueOf(this.defaultValue).equals(value.getDefaultValue());
        } else if (this.type == DecimalColumn.class) {
            DecimalColumn dc = (DecimalColumn)value;
            result = new BigDecimal(this.defaultValue).equals(dc.getDefaultValue());
        } else if (this.type == DateTimeColumn.class) {
            if ("GETDATE()".equalsIgnoreCase(this.defaultValue)) {
                result = ((DateTimeColumn)value).isGetdate();
            } else {
                try {
                    result = DateTimeColumn.parseISODate(this.defaultValue).equals(value.getDefaultValue());
                }
                catch (ParseException e) {
                    result = false;
                }
            }
        } else {
            result = this.type == StringColumn.class ? this.defaultValue.equals(StringColumn.quoteString(((StringColumn)value).getDefaultValue())) : this.defaultValue.equals(value.getDefaultValue());
        }
        return result;
    }
}

