/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.DBType;
import ru.curs.celesta.score.AbstractScore;
import ru.curs.celesta.score.AbstractSelectStmt;
import ru.curs.celesta.score.BasicTable;
import ru.curs.celesta.score.Between;
import ru.curs.celesta.score.BinaryLogicalOp;
import ru.curs.celesta.score.BinaryTermOp;
import ru.curs.celesta.score.BooleanLiteral;
import ru.curs.celesta.score.CelestaParserConstants;
import ru.curs.celesta.score.CelestaParserTokenManager;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.FKRule;
import ru.curs.celesta.score.FieldRef;
import ru.curs.celesta.score.GetDate;
import ru.curs.celesta.score.Grain;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.In;
import ru.curs.celesta.score.Index;
import ru.curs.celesta.score.IntegerLiteral;
import ru.curs.celesta.score.IsNull;
import ru.curs.celesta.score.Lower;
import ru.curs.celesta.score.MaterializedView;
import ru.curs.celesta.score.Max;
import ru.curs.celesta.score.Min;
import ru.curs.celesta.score.NotExpr;
import ru.curs.celesta.score.Parameter;
import ru.curs.celesta.score.ParameterRef;
import ru.curs.celesta.score.ParameterizedView;
import ru.curs.celesta.score.ParenthesizedExpr;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.RealLiteral;
import ru.curs.celesta.score.Relop;
import ru.curs.celesta.score.SequenceElement;
import ru.curs.celesta.score.SimpleCharStream;
import ru.curs.celesta.score.Sum;
import ru.curs.celesta.score.TableBuilder;
import ru.curs.celesta.score.TableElement;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.TextLiteral;
import ru.curs.celesta.score.Token;
import ru.curs.celesta.score.UnaryMinus;
import ru.curs.celesta.score.Upper;
import ru.curs.celesta.score.View;
import ru.curs.celesta.score.ViewColumnType;
import ru.curs.celesta.score.io.Resource;
import ru.curs.celesta.score.validator.IdentifierParser;

public class CelestaParser
implements CelestaParserConstants {
    public CelestaParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[101];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Expr parseComplexFilter(String filter, IdentifierParser identifierParser) {
        try (StringReader sr = new StringReader(filter);){
            CelestaParser parser = new CelestaParser(sr);
            Expr expr = parser.sqlExpression(identifierParser);
            return expr;
        }
        catch (ParseException e) {
            CelestaException ce = new CelestaException("Invalid complex filter '%s': %s", filter, e.getMessage());
            ce.initCause(e);
            throw ce;
        }
    }

    public final GrainPart extractGrainInfo(AbstractScore s, Resource r) throws ParseException {
        Token t;
        boolean isDefinition = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 99: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 99: {
                        this.jj_consume_token(99);
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                    }
                }
                this.jj_consume_token(15);
                this.jj_consume_token(63);
                t = this.jj_consume_token(94);
                isDefinition = true;
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                this.token_source.SwitchTo(4);
                this.jj_consume_token(63);
                t = this.jj_consume_token(94);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String grainName = s.getIdentifierParser().parse(t.toString());
        Grain grain = s.getGrains().get(grainName);
        if (grain == null) {
            grain = new Grain(s, t.toString());
        }
        if ("" != null) {
            return new GrainPart(grain, isDefinition, r);
        }
        throw new Error("Missing return statement in function");
    }

    public final Grain parseGrainPart(GrainPart grainPart) throws ParseException {
        Token doc = null;
        boolean val = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 99: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 99: {
                        doc = this.jj_consume_token(99);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                this.jj_consume_token(15);
                this.jj_consume_token(63);
                Token t = this.jj_consume_token(94);
                if (doc != null) {
                    grainPart.setCelestaDocLexem(doc.toString());
                    doc = null;
                }
                this.jj_consume_token(64);
                t = this.jj_consume_token(97);
                grainPart.setVersion(t.toString());
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        this.token_source.SwitchTo(2);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 37: {
                                this.jj_consume_token(37);
                                val = false;
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(74);
                        grainPart.setAutoupdate(val);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                this.token_source.SwitchTo(4);
                this.jj_consume_token(63);
                Token t = this.jj_consume_token(94);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(62);
        block32: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: 
                case 15: 
                case 19: 
                case 99: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block32;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 99: {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 99: {
                            doc = this.jj_consume_token(99);
                            break;
                        }
                        default: {
                            this.jj_la1[7] = this.jj_gen;
                        }
                    }
                    this.jj_consume_token(15);
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 56: {
                            this.createTable(grainPart, doc == null ? null : doc.toString());
                            break;
                        }
                        case 58: {
                            this.createIndex(grainPart, doc == null ? null : doc.toString());
                            break;
                        }
                        case 61: {
                            this.createView(grainPart, doc == null ? null : doc.toString());
                            break;
                        }
                        case 59: {
                            this.createMaterializedView(grainPart, doc == null ? null : doc.toString());
                            break;
                        }
                        case 57: {
                            this.createFunction(grainPart, doc == null ? null : doc.toString());
                            break;
                        }
                        case 60: {
                            this.createSequence(grainPart, doc == null ? null : doc.toString());
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    doc = null;
                    break;
                }
                case 7: {
                    this.jj_consume_token(7);
                    this.alterTable(grainPart);
                    break;
                }
                case 19: {
                    this.jj_consume_token(19);
                    this.executeNativeSql(grainPart);
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(62);
        }
        this.jj_consume_token(0);
        if ("" != null) {
            return grainPart.getGrain();
        }
        throw new Error("Missing return statement in function");
    }

    public final void createTable(GrainPart g, String doc) throws ParseException {
        TableBuilder table = null;
        Token t = null;
        boolean val = true;
        this.jj_consume_token(56);
        t = this.jj_consume_token(94);
        table = new TableBuilder(g, t.toString());
        table.setCelestaDocLexem(doc);
        this.jj_consume_token(102);
        this.tableConstituent(table);
        block20: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block20;
                }
            }
            this.jj_consume_token(103);
            this.tableConstituent(table);
        }
        this.jj_consume_token(104);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                this.jj_consume_token(51);
                this.token_source.SwitchTo(2);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 70: {
                        this.jj_consume_token(70);
                        this.jj_consume_token(71);
                        table.setVersioned(false);
                        table.setReadOnly(true);
                        break block3;
                    }
                    case 37: 
                    case 72: 
                    case 74: {
                        block21: while (true) {
                            val = true;
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 37: {
                                    this.jj_consume_token(37);
                                    val = false;
                                    break;
                                }
                                default: {
                                    this.jj_la1[11] = this.jj_gen;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 72: {
                                    this.jj_consume_token(72);
                                    this.jj_consume_token(73);
                                    table.setVersioned(val);
                                    break;
                                }
                                case 74: {
                                    this.jj_consume_token(74);
                                    table.setAutoUpdate(val);
                                    break;
                                }
                                default: {
                                    this.jj_la1[12] = this.jj_gen;
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 37: 
                                case 72: 
                                case 74: {
                                    continue block21;
                                }
                            }
                            break;
                        }
                        this.jj_la1[13] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        table.build();
    }

    public final void tableConstituent(TableBuilder table) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: 
            case 99: {
                this.columnDefinition(table);
                break;
            }
            case 13: 
            case 21: 
            case 42: {
                String name = this.constraint(table.getGrain());
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 42: {
                        this.primaryKey(table);
                        table.setPkConstraintName(name);
                        break block0;
                    }
                    case 21: {
                        TableBuilder.ForeignKeyBuilder fk = this.foreignKey(table);
                        fk.setConstraintName(name);
                        break block0;
                    }
                }
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void columnDefinition(TableBuilder table) throws ParseException {
        boolean nullable;
        TableBuilder.ColumnBuilder column = null;
        Token length = null;
        boolean negative = false;
        boolean pk = false;
        TableBuilder.ForeignKeyBuilder fk = null;
        Token doc = null;
        Object sequence = null;
        String defaultValue = null;
        Token precision = null;
        Token scale = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                doc = this.jj_consume_token(99);
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        Token t = this.jj_consume_token(94);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                column = table.integerColumn(t.toString());
                t = null;
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 90: 
                            case 93: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 93: {
                                        this.jj_consume_token(93);
                                        negative = true;
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[19] = this.jj_gen;
                                    }
                                }
                                t = this.jj_consume_token(90);
                                defaultValue = (negative ? "-" : "") + t.toString();
                                break block3;
                            }
                            case 36: {
                                defaultValue = this.sequenceNextVal();
                                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                    case 38: {
                                        this.jj_consume_token(38);
                                        this.jj_consume_token(39);
                                        nullable = false;
                                        break block3;
                                    }
                                }
                                this.jj_la1[20] = this.jj_gen;
                                break block3;
                            }
                        }
                        this.jj_la1[21] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                column = table.floatingColumn(t.toString());
                t = null;
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 93: {
                                this.jj_consume_token(93);
                                negative = true;
                                break;
                            }
                            default: {
                                this.jj_la1[23] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 90: {
                                t = this.jj_consume_token(90);
                                break;
                            }
                            case 89: {
                                t = this.jj_consume_token(89);
                                break;
                            }
                            default: {
                                this.jj_la1[24] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        defaultValue = (negative ? "-" : "") + t.toString();
                        break block3;
                    }
                }
                this.jj_la1[25] = this.jj_gen;
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                this.jj_consume_token(102);
                precision = this.jj_consume_token(90);
                this.jj_consume_token(103);
                scale = this.jj_consume_token(90);
                this.jj_consume_token(104);
                column = table.decimalColumn(t.toString(), Integer.parseInt(precision.toString()), Integer.parseInt(scale.toString()));
                t = null;
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 93: {
                                this.jj_consume_token(93);
                                negative = true;
                                break;
                            }
                            default: {
                                this.jj_la1[26] = this.jj_gen;
                            }
                        }
                        t = this.jj_consume_token(89);
                        defaultValue = (negative ? "-" : "") + t.toString();
                        break block3;
                    }
                }
                this.jj_la1[27] = this.jj_gen;
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                column = table.stringColumn(t.toString());
                t = null;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 102: {
                        this.jj_consume_token(102);
                        length = this.jj_consume_token(90);
                        this.jj_consume_token(104);
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                    }
                }
                column.setLength(length.toString());
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        t = this.jj_consume_token(97);
                        break block3;
                    }
                }
                this.jj_la1[29] = this.jj_gen;
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                column = table.stringColumn(t.toString());
                column.setLength("MAX");
                t = null;
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        t = this.jj_consume_token(97);
                        break block3;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                column = table.binaryColumn(t.toString());
                t = null;
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        t = this.jj_consume_token(92);
                        break block3;
                    }
                }
                this.jj_la1[31] = this.jj_gen;
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        this.token_source.SwitchTo(0);
                        this.jj_consume_token(80);
                        this.jj_consume_token(81);
                        column = table.zonedDateTimeColumn(t.toString());
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                    }
                }
                if (column == null) {
                    column = table.dateTimeColumn(t.toString());
                }
                t = null;
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 97: {
                                t = this.jj_consume_token(97);
                                break block3;
                            }
                            case 24: {
                                t = this.jj_consume_token(24);
                                this.jj_consume_token(102);
                                this.jj_consume_token(104);
                                break block3;
                            }
                        }
                        this.jj_la1[33] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[34] = this.jj_gen;
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                column = table.booleanColumn(t.toString());
                t = null;
                nullable = this.nullable();
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 97: {
                                t = this.jj_consume_token(97);
                                break block3;
                            }
                            case 90: {
                                t = this.jj_consume_token(90);
                                break block3;
                            }
                            case 20: {
                                t = this.jj_consume_token(20);
                                break block3;
                            }
                            case 49: {
                                t = this.jj_consume_token(49);
                                break block3;
                            }
                        }
                        this.jj_la1[35] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[36] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String name = this.constraint(table.getGrain());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                this.jj_consume_token(30);
                pk = true;
                table.setPkConstraintName(name);
                name = this.constraint(table.getGrain());
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        column.setNullableAndDefault(nullable, (String)(defaultValue != null ? defaultValue : (t == null ? null : t.toString())));
        column.setCelestaDocLexem(doc == null ? null : doc.toString());
        if (pk) {
            table.addPK(column.getName());
            table.finalizePK();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                this.jj_consume_token(30);
                fk = table.foreignKey();
                fk.addColumn(column.getName());
                fk.setConstraintName(name);
                this.references(fk);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
    }

    public final boolean nullable() throws ParseException {
        boolean result = true;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: 
            case 39: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 39: {
                        this.jj_consume_token(39);
                        result = true;
                        break block0;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        this.jj_consume_token(39);
                        result = false;
                        break block0;
                    }
                }
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final void primaryKey(TableBuilder table) throws ParseException {
        IdentifierParser identifierParser = table.getGrain().getScore().getIdentifierParser();
        this.jj_consume_token(42);
        this.jj_consume_token(30);
        this.jj_consume_token(102);
        Token t = this.jj_consume_token(94);
        table.addPK(t.toString());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(103);
            t = this.jj_consume_token(94);
            table.addPK(t.toString());
        }
        this.jj_consume_token(104);
        table.finalizePK();
    }

    public final TableBuilder.ForeignKeyBuilder foreignKey(TableBuilder table) throws ParseException {
        this.jj_consume_token(21);
        this.jj_consume_token(30);
        TableBuilder.ForeignKeyBuilder fk = table.foreignKey();
        this.jj_consume_token(102);
        Token t = this.jj_consume_token(94);
        fk.addColumn(t.toString());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(103);
            t = this.jj_consume_token(94);
            fk.addColumn(t.toString());
        }
        this.jj_consume_token(104);
        this.references(fk);
        if ("" != null) {
            return fk;
        }
        throw new Error("Missing return statement in function");
    }

    public final void references(TableBuilder.ForeignKeyBuilder fk) throws ParseException {
        Token t2 = null;
        this.jj_consume_token(43);
        Token t = this.jj_consume_token(94);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                t2 = this.jj_consume_token(94);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if (t2 == null) {
            fk.setReferencedTable("", t.toString());
        } else {
            fk.setReferencedTable(t.toString(), t2.toString());
        }
        this.jj_consume_token(102);
        t = this.jj_consume_token(94);
        fk.addReferencedColumn(t.toString());
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block19;
                }
            }
            this.jj_consume_token(103);
            t = this.jj_consume_token(94);
            fk.addReferencedColumn(t.toString());
        }
        this.jj_consume_token(104);
        fk.finalizeReference();
        block6 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 50: {
                        this.jj_consume_token(50);
                        FKRule action = this.action();
                        fk.setUpdateRule(action);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 40: {
                                this.jj_consume_token(40);
                                this.jj_consume_token(17);
                                action = this.action();
                                fk.setDeleteRule(action);
                                break block6;
                            }
                        }
                        this.jj_la1[46] = this.jj_gen;
                        break block6;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        FKRule action = this.action();
                        fk.setDeleteRule(action);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 40: {
                                this.jj_consume_token(40);
                                this.jj_consume_token(50);
                                action = this.action();
                                fk.setUpdateRule(action);
                                break block6;
                            }
                        }
                        this.jj_la1[47] = this.jj_gen;
                        break block6;
                    }
                }
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
    }

    public final FKRule action() throws ParseException {
        FKRule result;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 37: {
                this.jj_consume_token(37);
                this.jj_consume_token(5);
                result = FKRule.NO_ACTION;
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(39);
                result = FKRule.SET_NULL;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                result = FKRule.CASCADE;
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final void createIndex(GrainPart g, String doc) throws ParseException {
        this.jj_consume_token(58);
        Token indexName = this.jj_consume_token(94);
        this.jj_consume_token(40);
        Token tableName = this.jj_consume_token(94);
        Index ind = new Index(g, tableName.toString(), indexName.toString());
        ind.setCelestaDocLexem(doc);
        this.jj_consume_token(102);
        Token columnName = this.jj_consume_token(94);
        ind.addColumn(columnName.toString());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[51] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(103);
            columnName = this.jj_consume_token(94);
            ind.addColumn(columnName.toString());
        }
        this.jj_consume_token(104);
        ind.finalizeIndex();
    }

    public final void alterTable(GrainPart g) throws ParseException {
        IdentifierParser identifierParser = g.getGrain().getScore().getIdentifierParser();
        this.jj_consume_token(56);
        Token t = this.jj_consume_token(94);
        BasicTable table = g.getGrain().getElement(identifierParser.parse(t.toString()), BasicTable.class);
        this.jj_consume_token(6);
        String name = this.constraint(g.getGrain());
        TableBuilder tb = new TableBuilder(table);
        TableBuilder.ForeignKeyBuilder fk = this.foreignKey(tb);
        fk.setConstraintName(name);
        tb.build();
    }

    public final String constraint(Grain g) throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                t = this.jj_consume_token(94);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
            }
        }
        if (t == null) {
            if ("" != null) {
                return null;
            }
        } else {
            g.addConstraintName(t.toString());
            if ("" != null) {
                return t.toString();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final void createView(GrainPart g, String doc) throws ParseException {
        View view = null;
        Token viewName = null;
        this.jj_consume_token(61);
        viewName = this.jj_consume_token(94);
        this.jj_consume_token(9);
        view = new View(g, viewName.toString());
        view.setCelestaDocLexem(doc);
        this.unionAll(view);
    }

    public final void unionAll(View view) throws ParseException {
        AbstractSelectStmt selectStmt = view.addSelectStatement();
        this.select(selectStmt);
        selectStmt.finalizeParsing();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 53: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(53);
            this.jj_consume_token(55);
            selectStmt = view.addSelectStatement();
            this.select(selectStmt);
            selectStmt.finalizeParsing();
        }
        view.finalizeParsing();
    }

    public final void createMaterializedView(GrainPart g, String doc) throws ParseException {
        MaterializedView view = null;
        Token viewName = null;
        AbstractSelectStmt selectStmt = null;
        this.jj_consume_token(59);
        this.jj_consume_token(61);
        viewName = this.jj_consume_token(94);
        this.jj_consume_token(9);
        view = new MaterializedView(g, viewName.toString());
        view.setCelestaDocLexem(doc);
        selectStmt = view.addSelectStatement();
        this.materializedSelect(selectStmt);
        selectStmt.finalizeParsing();
        view.finalizeParsing();
    }

    public final void createFunction(GrainPart g, String doc) throws ParseException {
        ParameterizedView v = null;
        Token viewName = null;
        this.jj_consume_token(57);
        viewName = this.jj_consume_token(94);
        v = new ParameterizedView(g, viewName.toString());
        v.setCelestaDocLexem(doc);
        this.jj_consume_token(102);
        this.functionParam(v);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(103);
            this.functionParam(v);
        }
        this.jj_consume_token(104);
        this.jj_consume_token(9);
        this.unionAll(v);
    }

    public final void createSequence(GrainPart g, String doc) throws ParseException {
        SequenceElement s;
        block11: {
            s = null;
            Token name = null;
            this.jj_consume_token(60);
            name = this.jj_consume_token(94);
            s = new SequenceElement(g, name.toString());
            s.setCelestaDocLexem(doc);
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 68: {
                        this.sequenceStartWith(s);
                        continue block10;
                    }
                    case 69: {
                        this.sequenceIncrementBy(s);
                        continue block10;
                    }
                    case 67: {
                        this.sequenceMinValue(s);
                        continue block10;
                    }
                    case 66: {
                        this.sequenceMaxValue(s);
                        continue block10;
                    }
                    case 65: {
                        this.sequenceCycle(s);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[56] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        s.finalizeParsing();
    }

    public final void sequenceStartWith(SequenceElement s) throws ParseException {
        this.jj_consume_token(68);
        this.jj_consume_token(51);
        long val = this.signedInteger();
        s.startWith(val);
    }

    public final void sequenceIncrementBy(SequenceElement s) throws ParseException {
        this.jj_consume_token(69);
        this.jj_consume_token(11);
        long val = this.signedInteger();
        s.incrementBy(val);
    }

    public final long signedInteger() throws ParseException {
        int sign = 1;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 93: {
                this.jj_consume_token(93);
                sign = -1;
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        Token val = this.jj_consume_token(90);
        if ("" != null) {
            return (long)sign * Long.parseLong(val.image);
        }
        throw new Error("Missing return statement in function");
    }

    public final void sequenceMinValue(SequenceElement s) throws ParseException {
        this.jj_consume_token(67);
        long val = this.signedInteger();
        s.minValue(val);
    }

    public final void sequenceMaxValue(SequenceElement s) throws ParseException {
        this.jj_consume_token(66);
        long val = this.signedInteger();
        s.maxValue(val);
    }

    public final void sequenceCycle(SequenceElement s) throws ParseException {
        this.jj_consume_token(65);
        s.setIsCycle(true);
    }

    public final void functionParam(ParameterizedView view) throws ParseException {
        Parameter p;
        Token doc = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                doc = this.jj_consume_token(99);
                break;
            }
            default: {
                this.jj_la1[58] = this.jj_gen;
            }
        }
        Token t = this.jj_consume_token(94);
        String name = t.toString();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                p = new Parameter(name, ViewColumnType.INT);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                p = new Parameter(name, ViewColumnType.REAL);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                p = new Parameter(name, ViewColumnType.DECIMAL);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                p = new Parameter(name, ViewColumnType.TEXT);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                p = new Parameter(name, ViewColumnType.TEXT);
                break;
            }
            case 87: {
                this.jj_consume_token(87);
                p = new Parameter(name, ViewColumnType.DATE);
                break;
            }
            case 88: {
                this.jj_consume_token(88);
                p = new Parameter(name, ViewColumnType.BIT);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        p.setCelestaDocLexem(doc == null ? null : doc.toString());
        view.addParameter(p);
    }

    public final Expr sqlExpression(IdentifierParser identifierParser) throws ParseException {
        ArrayList<Expr> operands = new ArrayList<Expr>(5);
        Expr result = this.sqlAndExpression(identifierParser);
        operands.add(result);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(41);
            result = this.sqlAndExpression(identifierParser);
            operands.add(result);
        }
        if ("" != null) {
            return operands.size() == 1 ? result : new BinaryLogicalOp(1, operands);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr sqlAndExpression(IdentifierParser identifierParser) throws ParseException {
        ArrayList<Expr> operands = new ArrayList<Expr>(5);
        Expr result = this.sqlUnaryLogicalExpression(identifierParser);
        operands.add(result);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            result = this.sqlUnaryLogicalExpression(identifierParser);
            operands.add(result);
        }
        if ("" != null) {
            return operands.size() == 1 ? result : new BinaryLogicalOp(0, operands);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr sqlUnaryLogicalExpression(IdentifierParser identifierParser) throws ParseException {
        boolean isNot = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 38: {
                this.jj_consume_token(38);
                isNot = true;
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
        Expr result = this.sqlRelationalExpression(identifierParser);
        if ("" != null) {
            return isNot ? new NotExpr(result) : result;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr sqlRelationalExpression(IdentifierParser identifierParser) throws ParseException {
        ArrayList<Expr> operands = new ArrayList<Expr>(5);
        Expr result = this.sqlTermExpr(identifierParser);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 10: 
            case 26: 
            case 28: 
            case 32: 
            case 106: 
            case 107: 
            case 108: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 106: 
                    case 107: 
                    case 108: {
                        int relop = this.relop();
                        Expr buf1 = this.sqlTermExpr(identifierParser);
                        result = new Relop(result, buf1, relop);
                        break block0;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        this.jj_consume_token(102);
                        Expr buf1 = this.sqlTermExpr(identifierParser);
                        operands.add(buf1);
                        block13: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 103: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[63] = this.jj_gen;
                                    break block13;
                                }
                            }
                            this.jj_consume_token(103);
                            buf1 = this.sqlTermExpr(identifierParser);
                            operands.add(buf1);
                        }
                        this.jj_consume_token(104);
                        result = new In(result, operands);
                        break block0;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        Expr buf1 = this.sqlTermExpr(identifierParser);
                        this.jj_consume_token(8);
                        Expr buf2 = this.sqlTermExpr(identifierParser);
                        result = new Between(result, buf1, buf2);
                        break block0;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        Expr buf1 = this.sqlTermExpr(identifierParser);
                        result = new Relop(result, buf1, 6);
                        break block0;
                    }
                    case 28: {
                        this.jj_consume_token(28);
                        this.jj_consume_token(39);
                        result = new IsNull(result);
                        break block0;
                    }
                }
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[65] = this.jj_gen;
            }
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final int relop() throws ParseException {
        int result;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 106: {
                this.jj_consume_token(106);
                result = 5;
                break;
            }
            case 107: {
                this.jj_consume_token(107);
                result = 0;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 106: {
                        this.jj_consume_token(106);
                        result = 2;
                        break block0;
                    }
                }
                this.jj_la1[66] = this.jj_gen;
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                result = 1;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 106: 
                    case 107: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 106: {
                                this.jj_consume_token(106);
                                result = 3;
                                break block0;
                            }
                            case 107: {
                                this.jj_consume_token(107);
                                result = 4;
                                break block0;
                            }
                        }
                        this.jj_la1[67] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[68] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr sqlTermExpr(IdentifierParser identifierParser) throws ParseException {
        ArrayList<Expr> operands = new ArrayList<Expr>(5);
        int operator = -1;
        Expr result = this.sqlMultiplicativeExpression(identifierParser);
        operands.add(result);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 93: 
                case 109: 
                case 110: {
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 109: {
                    this.jj_consume_token(109);
                    operator = 0;
                    break;
                }
                case 93: {
                    this.jj_consume_token(93);
                    operator = 1;
                    break;
                }
                case 110: {
                    this.jj_consume_token(110);
                    operator = 4;
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            result = this.sqlMultiplicativeExpression(identifierParser);
            operands.add(result);
        }
        if ("" != null) {
            return operands.size() == 1 ? result : new BinaryTermOp(operator, operands);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr sqlMultiplicativeExpression(IdentifierParser identifierParser) throws ParseException {
        ArrayList<Expr> operands = new ArrayList<Expr>(5);
        int operator = -1;
        Expr result = this.sqlUnaryExpression(identifierParser);
        operands.add(result);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 111: 
                case 112: {
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 111: {
                    this.jj_consume_token(111);
                    operator = 2;
                    break;
                }
                case 112: {
                    this.jj_consume_token(112);
                    operator = 3;
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            result = this.sqlUnaryExpression(identifierParser);
            operands.add(result);
        }
        if ("" != null) {
            return operands.size() == 1 ? result : new BinaryTermOp(operator, operands);
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr sqlUnaryExpression(IdentifierParser identifierParser) throws ParseException {
        boolean isMinus = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 24: 
            case 49: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 102: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 93: {
                        this.jj_consume_token(93);
                        isMinus = true;
                        break;
                    }
                    default: {
                        this.jj_la1[74] = this.jj_gen;
                    }
                }
                Expr result = this.sqlPrimaryExpression(identifierParser);
                if ("" == null) break;
                return isMinus ? new UnaryMinus(result) : result;
            }
            case 54: {
                this.jj_consume_token(54);
                this.jj_consume_token(102);
                Expr result = this.sqlTermExpr(identifierParser);
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Upper(result);
            }
            case 33: {
                this.jj_consume_token(33);
                this.jj_consume_token(102);
                Expr result = this.sqlTermExpr(identifierParser);
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Lower(result);
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr sqlPrimaryExpression(IdentifierParser identifierParser) throws ParseException {
        Expr result;
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 90: {
                t = this.jj_consume_token(90);
                result = new IntegerLiteral(t.toString());
                break;
            }
            case 89: {
                t = this.jj_consume_token(89);
                result = new RealLiteral(t.toString());
                break;
            }
            case 97: {
                t = this.jj_consume_token(97);
                result = new TextLiteral(t.toString());
                break;
            }
            case 95: {
                t = this.jj_consume_token(95);
                result = new ParameterRef(t.toString().substring(1));
                break;
            }
            case 49: {
                t = this.jj_consume_token(49);
                result = new BooleanLiteral(true);
                break;
            }
            case 20: {
                t = this.jj_consume_token(20);
                result = new BooleanLiteral(false);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                this.jj_consume_token(102);
                this.jj_consume_token(104);
                result = new GetDate();
                break;
            }
            case 102: {
                this.jj_consume_token(102);
                result = this.sqlExpression(identifierParser);
                this.jj_consume_token(104);
                result = new ParenthesizedExpr(result);
                break;
            }
            case 94: {
                result = this.fieldReference(identifierParser);
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return result;
        }
        throw new Error("Missing return statement in function");
    }

    public final FieldRef fieldReference(IdentifierParser identifierParser) throws ParseException {
        String tableName = null;
        Token t = this.jj_consume_token(94);
        String fieldName = identifierParser.parse(t.toString());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                t = this.jj_consume_token(94);
                tableName = fieldName;
                fieldName = identifierParser.parse(t.toString());
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
            }
        }
        if ("" != null) {
            return new FieldRef(tableName, fieldName);
        }
        throw new Error("Missing return statement in function");
    }

    public final void select(AbstractSelectStmt v) throws ParseException {
        this.jj_consume_token(45);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 18: {
                this.jj_consume_token(18);
                v.setDistinct(true);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        this.selectItem(v);
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[79] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(103);
            this.selectItem(v);
        }
        this.jj_consume_token(22);
        this.fromClause(v);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 52: {
                this.jj_consume_token(52);
                Expr where = this.sqlExpression(v.getGrain().getScore().getIdentifierParser());
                v.setWhereCondition(where);
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                this.jj_consume_token(11);
                this.groupBy(v);
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
            }
        }
    }

    public final void materializedSelect(AbstractSelectStmt v) throws ParseException {
        this.jj_consume_token(45);
        this.materializedSelectItem(v);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(103);
            this.materializedSelectItem(v);
        }
        this.jj_consume_token(22);
        this.materializedFromClause(v);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                this.jj_consume_token(11);
                this.groupBy(v);
                break;
            }
            default: {
                this.jj_la1[83] = this.jj_gen;
            }
        }
    }

    public final void groupBy(AbstractSelectStmt view) throws ParseException {
        FieldRef fr = this.fieldReference(view.getGrain().getScore().getIdentifierParser());
        view.addGroupByColumn(fr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 103: {
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(103);
            fr = this.fieldReference(view.getGrain().getScore().getIdentifierParser());
            view.addGroupByColumn(fr);
        }
    }

    public final Expr aggregateFunc(AbstractSelectStmt v) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.jj_consume_token(102);
                this.jj_consume_token(111);
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Count();
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(102);
                Expr term = this.sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Sum(term);
            }
            case 34: {
                this.jj_consume_token(34);
                this.jj_consume_token(102);
                Expr term = this.sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Max(term);
            }
            case 35: {
                this.jj_consume_token(35);
                this.jj_consume_token(102);
                Expr term = this.sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Min(term);
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final Expr materializedAggregateFunc(AbstractSelectStmt v) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.jj_consume_token(102);
                this.jj_consume_token(111);
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Count();
            }
            case 47: {
                this.jj_consume_token(47);
                this.jj_consume_token(102);
                FieldRef term = this.fieldReference(v.getGrain().getScore().getIdentifierParser());
                this.jj_consume_token(104);
                if ("" == null) break;
                return new Sum(term);
            }
            default: {
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final void selectItem(AbstractSelectStmt v) throws ParseException {
        Expr expr;
        Token doc = null;
        Token aliasToken = null;
        String alias = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                doc = this.jj_consume_token(99);
                break;
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 20: 
            case 24: 
            case 33: 
            case 49: 
            case 54: 
            case 89: 
            case 90: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 102: {
                expr = this.sqlTermExpr(v.getGrain().getScore().getIdentifierParser());
                break;
            }
            case 14: 
            case 34: 
            case 35: 
            case 47: {
                expr = this.aggregateFunc(v);
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: {
                aliasToken = this.jj_consume_token(94);
                alias = aliasToken.toString();
                break;
            }
            default: {
                this.jj_la1[90] = this.jj_gen;
            }
        }
        if (alias.isEmpty() && expr instanceof FieldRef) {
            alias = ((FieldRef)expr).getColumnName();
        }
        if (doc != null) {
            expr.getMeta().setCelestaDocLexem(doc.toString());
        }
        v.addColumn(alias, expr);
    }

    public final void materializedSelectItem(AbstractSelectStmt v) throws ParseException {
        Expr expr;
        Token doc = null;
        Token aliasToken = null;
        String alias = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 99: {
                doc = this.jj_consume_token(99);
                break;
            }
            default: {
                this.jj_la1[91] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: {
                expr = this.fieldReference(v.getGrain().getScore().getIdentifierParser());
                break;
            }
            case 14: 
            case 47: {
                expr = this.materializedAggregateFunc(v);
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: {
                aliasToken = this.jj_consume_token(94);
                alias = aliasToken.toString();
                break;
            }
            default: {
                this.jj_la1[94] = this.jj_gen;
            }
        }
        if (alias.isEmpty() && expr instanceof FieldRef) {
            alias = ((FieldRef)expr).getColumnName();
        }
        if (doc != null) {
            expr.getMeta().setCelestaDocLexem(doc.toString());
        }
        v.addColumn(alias, expr);
    }

    public final TableRef tableReference(AbstractSelectStmt v, boolean lookupMViews) throws ParseException {
        TableElement tab;
        String grainName = null;
        String tableName = null;
        IdentifierParser identifierParser = v.getGrain().getScore().getIdentifierParser();
        Token t = this.jj_consume_token(94);
        String alias = tableName = t.toString();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 105: {
                this.jj_consume_token(105);
                t = this.jj_consume_token(94);
                grainName = tableName;
                alias = tableName = t.toString();
                break;
            }
            default: {
                this.jj_la1[95] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: {
                t = this.jj_consume_token(94);
                alias = t.toString();
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        Grain g = grainName == null ? v.getGrain() : v.getGrain().getScore().getGrainAsDependency(v.getGrain(), grainName);
        TableElement tableElement = tab = lookupMViews ? (TableElement)g.getMaterializedViews().get(identifierParser.parse(tableName)) : null;
        if (tab == null) {
            tab = g.getElement(identifierParser.parse(tableName), BasicTable.class);
        }
        if ("" != null) {
            return new TableRef(tab, identifierParser.parse(alias));
        }
        throw new Error("Missing return statement in function");
    }

    public final String sequenceNextVal() throws ParseException {
        String sequenceName = null;
        this.jj_consume_token(36);
        this.jj_consume_token(102);
        Token t = this.jj_consume_token(94);
        this.jj_consume_token(104);
        sequenceName = t.toString();
        if ("" != null) {
            return "NEXTVAL(" + sequenceName + ")";
        }
        throw new Error("Missing return statement in function");
    }

    public final void materializedFromClause(AbstractSelectStmt v) throws ParseException {
        TableRef tRef = this.tableReference(v, false);
        v.addFromTableRef(tRef);
    }

    public final void fromClause(AbstractSelectStmt v) throws ParseException {
        TableRef tRef = this.tableReference(v, true);
        v.addFromTableRef(tRef);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 27: 
                case 31: 
                case 44: {
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    break block3;
                }
            }
            tRef = this.join(v);
            v.addFromTableRef(tRef);
        }
    }

    public final TableRef join(AbstractSelectStmt v) throws ParseException {
        TableRef.JoinType jt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 27: {
                this.jj_consume_token(27);
                jt = TableRef.JoinType.INNER;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                jt = TableRef.JoinType.LEFT;
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                jt = TableRef.JoinType.RIGHT;
                break;
            }
            default: {
                this.jj_la1[99] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(29);
        TableRef tRef = this.tableReference(v, true);
        this.jj_consume_token(40);
        Expr onExpr = this.sqlExpression(v.getGrain().getScore().getIdentifierParser());
        tRef.setJoinType(jt);
        tRef.setOnExpr(onExpr);
        if ("" != null) {
            return tRef;
        }
        throw new Error("Missing return statement in function");
    }

    public final void executeNativeSql(GrainPart g) throws ParseException {
        boolean isBefore = false;
        this.jj_consume_token(75);
        Token dbType = this.jj_consume_token(76);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                isBefore = true;
                break;
            }
            case 78: {
                this.jj_consume_token(78);
                break;
            }
            default: {
                this.jj_la1[100] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Token sql = this.jj_consume_token(77);
        g.getGrain().addNativeSql(sql.toString(), isBefore, DBType.getByNameIgnoreCase(dbType.toString()), g);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 32768, 0, 0, 0, 32768, 557184, 0, 0, 557184, 0, 0, 0, 0, 0, 0, 0x200000, 0x202000, 0, 0, 0, 0, 65536, 0, 0, 65536, 0, 65536, 0, 65536, 65536, 65536, 0, 0x1000000, 65536, 0x100000, 65536, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 4096, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0x14000400, 0x14000400, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1100000, 0x1100000, 0, 262144, 0, 0, 0x2000000, 0, 0x2000000, 0, 16384, 16384, 0, 0x1104000, 512, 0, 0, 16384, 512, 0, 0, 512, 0, -2013265920, -2013265920, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 16384, 0, 32, 524288, 16384, 0, 0, 0x3F000000, 0, 0, 32, 0, 32, 32, 524288, 1024, 1024, 0, 0, 64, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 131072, 0, 65536, 1024, 0, 192, 192, 0, 0, 0, 0, 256, 256, 262144, 256, 16416, 0, 0, 0x200000, 0, 0, 0, 0, 0, 65536, 512, 0, 64, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x420002, 131072, 0, 0, 0, 0x100000, 0, 0, 0, 0, 32780, 32768, 0, 4358158, 0, 0, 0, 32768, 0, 0, 0, 0, 0, 4096, 4096, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1280, 1280, 1344, 0, 0, 0x40000000, 0, 0x20000000, 0, 0x24000000, 0, 0x20000000, 0x6000000, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 33292288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 0x20000000, 0, 29097984, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0x20000000, 0, 0, 0x20000000, -436207616, -973078528, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -436207616, 0, 0x40000000, 0, 0x40000000, 0, 0x40000000, 0, 0, 0x40000000, 0, 0, 49152};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{8, 8, 8, 0, 0, 8, 8, 8, 0, 8, 128, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 128, 128, 512, 128, 0, 0, 0, 0, 0, 128, 0, 0, 128, 0, 0, 0, 8, 0, 0, 0, 0, 128, 7168, 7168, 1024, 3072, 3072, 7168, 24576, 24576, 98304, 98304, 0, 66, 66, 512, 0, 128, 0, 0, 128, 0, 128, 0, 0, 8, 66, 0, 0, 8, 0, 0, 0, 512, 0, 0, 0, 0, 0};
    }

    public CelestaParser(InputStream stream) {
        this(stream, null);
    }

    public CelestaParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CelestaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CelestaParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CelestaParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new CelestaParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CelestaParser(CelestaParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(CelestaParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 101; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[113];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 101; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 113; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        CelestaParser.jj_la1_init_0();
        CelestaParser.jj_la1_init_1();
        CelestaParser.jj_la1_init_2();
        CelestaParser.jj_la1_init_3();
    }
}

