/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import ru.curs.celesta.score.AbstractView;
import ru.curs.celesta.score.Between;
import ru.curs.celesta.score.BinaryLogicalOp;
import ru.curs.celesta.score.BinaryTermOp;
import ru.curs.celesta.score.BooleanLiteral;
import ru.curs.celesta.score.Count;
import ru.curs.celesta.score.Expr;
import ru.curs.celesta.score.ExprVisitor;
import ru.curs.celesta.score.FieldRef;
import ru.curs.celesta.score.GetDate;
import ru.curs.celesta.score.In;
import ru.curs.celesta.score.IntegerLiteral;
import ru.curs.celesta.score.IsNull;
import ru.curs.celesta.score.Lower;
import ru.curs.celesta.score.Max;
import ru.curs.celesta.score.Min;
import ru.curs.celesta.score.NotExpr;
import ru.curs.celesta.score.ParameterRef;
import ru.curs.celesta.score.ParenthesizedExpr;
import ru.curs.celesta.score.ParseException;
import ru.curs.celesta.score.RealLiteral;
import ru.curs.celesta.score.Relop;
import ru.curs.celesta.score.Sum;
import ru.curs.celesta.score.TableRef;
import ru.curs.celesta.score.TextLiteral;
import ru.curs.celesta.score.UnaryMinus;
import ru.curs.celesta.score.Upper;

public class SQLGenerator
extends ExprVisitor {
    private Deque<String> stack = new LinkedList<String>();

    final String generateSQL(Expr e) {
        try {
            e.accept(this);
        }
        catch (ParseException e1) {
            throw new RuntimeException(e1);
        }
        return this.stack.pop();
    }

    @Override
    final void visitBetween(Between expr) throws ParseException {
        String right2 = this.stack.pop();
        String right1 = this.stack.pop();
        String left = this.stack.pop();
        this.stack.push(String.format("%s BETWEEN %s AND %s", left, right1, right2));
    }

    @Override
    final void visitBinaryLogicalOp(BinaryLogicalOp expr) throws ParseException {
        StringBuilder result = new StringBuilder();
        String op = BinaryLogicalOp.OPS[expr.getOperator()];
        LinkedList<String> operands = new LinkedList<String>();
        for (int i = 0; i < expr.getOperands().size(); ++i) {
            operands.push(this.stack.pop());
        }
        boolean needOp = false;
        for (String operand : operands) {
            if (needOp) {
                result.append(op);
            }
            result.append(operand);
            needOp = true;
        }
        this.stack.push(result.toString());
    }

    @Override
    final void visitBinaryTermOp(BinaryTermOp expr) throws ParseException {
        StringBuilder result = new StringBuilder();
        LinkedList<String> operands = new LinkedList<String>();
        for (int i = 0; i < expr.getOperands().size(); ++i) {
            operands.push(this.stack.pop());
        }
        if (expr.getOperator() == 4) {
            this.concat(result, operands);
        } else {
            String op = BinaryTermOp.OPS[expr.getOperator()];
            boolean needOp = false;
            for (String operand : operands) {
                if (needOp) {
                    result.append(op);
                }
                result.append(operand);
                needOp = true;
            }
        }
        this.stack.push(result.toString());
    }

    @Override
    final void visitFieldRef(FieldRef expr) throws ParseException {
        StringBuilder result = new StringBuilder();
        if (expr.getTableNameOrAlias() != null) {
            if (this.quoteNames()) {
                result.append("\"");
            }
            result.append(expr.getTableNameOrAlias());
            if (this.quoteNames()) {
                result.append("\"");
            }
            result.append(".");
        }
        if (this.quoteNames()) {
            result.append("\"");
        }
        result.append(expr.getColumnName());
        if (this.quoteNames()) {
            result.append("\"");
        }
        this.stack.push(result.toString());
    }

    @Override
    void visitParameterRef(ParameterRef expr) throws ParseException {
        this.stack.push(this.paramLiteral(expr.getName()));
    }

    @Override
    final void visitIn(In expr) throws ParseException {
        StringBuilder result = new StringBuilder();
        LinkedList<String> operands = new LinkedList<String>();
        for (int i = 0; i < expr.getOperands().size(); ++i) {
            operands.push(this.stack.pop());
        }
        result.append(this.stack.pop());
        result.append(" IN (");
        boolean needComma = false;
        for (String operand : operands) {
            if (needComma) {
                result.append(", ");
            }
            result.append(operand);
            needComma = true;
        }
        result.append(")");
        this.stack.push(result.toString());
    }

    @Override
    final void visitIsNull(IsNull expr) throws ParseException {
        this.stack.push(this.stack.pop() + " IS NULL");
    }

    @Override
    final void visitNotExpr(NotExpr expr) throws ParseException {
        this.stack.push("NOT " + this.stack.pop());
    }

    @Override
    final void visitRealLiteral(RealLiteral expr) throws ParseException {
        this.stack.push(expr.getLexValue());
    }

    @Override
    final void visitIntegerLiteral(IntegerLiteral expr) throws ParseException {
        this.stack.push(expr.getLexValue());
    }

    @Override
    final void visitParenthesizedExpr(ParenthesizedExpr expr) throws ParseException {
        this.stack.push("(" + this.stack.pop() + ")");
    }

    @Override
    final void visitRelop(Relop expr) throws ParseException {
        String right = this.stack.pop();
        String left = this.stack.pop();
        this.stack.push(left + Relop.OPS[expr.getRelop()] + right);
    }

    @Override
    final void visitTextLiteral(TextLiteral expr) throws ParseException {
        String val = this.checkForDate(expr.getLexValue());
        this.stack.push(val);
    }

    @Override
    final void visitBooleanLiteral(BooleanLiteral expr) throws ParseException {
        this.stack.push(this.boolLiteral(expr.getValue()));
    }

    @Override
    void visitUpper(Upper expr) throws ParseException {
        this.stack.push("UPPER(" + this.stack.pop() + ")");
    }

    @Override
    void visitLower(Lower expr) throws ParseException {
        this.stack.push("LOWER(" + this.stack.pop() + ")");
    }

    protected String boolLiteral(boolean val) {
        return val ? "true" : "false";
    }

    protected String paramLiteral(String paramName) {
        return "$" + paramName;
    }

    protected String getDate() {
        return "GETDATE()";
    }

    protected String checkForDate(String lexValue) {
        return lexValue;
    }

    @Override
    final void visitUnaryMinus(UnaryMinus expr) throws ParseException {
        this.stack.push("-" + this.stack.pop());
    }

    @Override
    final void visitGetDate(GetDate expr) throws ParseException {
        this.stack.push(this.getDate());
    }

    protected boolean quoteNames() {
        return true;
    }

    protected String concat() {
        return " || ";
    }

    protected void concat(StringBuilder result, List<String> operands) {
        boolean needOp = false;
        for (String operand : operands) {
            if (needOp) {
                result.append(this.concat());
            }
            result.append(operand);
            needOp = true;
        }
    }

    protected String preamble(AbstractView view) {
        return String.format("create or replace view %s as", this.viewName(view));
    }

    protected String viewName(AbstractView v) {
        return String.format("%s.%s", v.getGrain().getQuotedName(), v.getQuotedName());
    }

    protected String tableName(TableRef t) {
        return String.format("%s.%s as \"%s\"", t.getTable().getGrain().getQuotedName(), t.getTable().getQuotedName(), t.getAlias());
    }

    @Override
    void visitCount(Count expr) throws ParseException {
        this.stack.push("COUNT(*)");
    }

    @Override
    void visitSum(Sum expr) throws ParseException {
        this.stack.push("SUM(" + this.stack.pop() + ")");
    }

    @Override
    void visitMax(Max expr) throws ParseException {
        this.stack.push("MAX(" + this.stack.pop() + ")");
    }

    @Override
    void visitMin(Min expr) throws ParseException {
        this.stack.push("MIN(" + this.stack.pop() + ")");
    }
}

