/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import ru.curs.celesta.score.GrainElement;
import ru.curs.celesta.score.GrainPart;
import ru.curs.celesta.score.ParseException;

public final class SequenceElement
extends GrainElement {
    private static final String DUPLICATE_ENTRANCE_TEMPLATE = "Duplicate entrance of %s was detected for sequence %s";
    private final Map<Argument, Object> arguments = new LinkedHashMap<Argument, Object>();

    SequenceElement(GrainPart grainPart, String name) throws ParseException {
        super(grainPart, name);
        this.getGrain().addElement(this);
    }

    void startWith(Long startWith) throws ParseException {
        if (this.arguments.putIfAbsent(Argument.START_WITH, startWith) != null) {
            throw new ParseException(String.format(DUPLICATE_ENTRANCE_TEMPLATE, new Object[]{Argument.START_WITH, this.getName()}));
        }
    }

    void incrementBy(Long incrementBy) throws ParseException {
        if (incrementBy == 0L) {
            throw new ParseException(String.format("Sequence %s has illegal value 0 for INCREMENT BY expression.", this.getName()));
        }
        if (this.arguments.putIfAbsent(Argument.INCREMENT_BY, incrementBy) != null) {
            throw new ParseException(String.format(DUPLICATE_ENTRANCE_TEMPLATE, new Object[]{Argument.INCREMENT_BY, this.getName()}));
        }
    }

    void minValue(Long minValue) throws ParseException {
        if (this.arguments.containsKey((Object)Argument.MAXVALUE) && (Long)this.arguments.get((Object)Argument.MAXVALUE) <= minValue) {
            throw new ParseException(String.format("MINVALUE for sequence %s must be less than MAXVALUE", this.getName()));
        }
        if (this.arguments.putIfAbsent(Argument.MINVALUE, minValue) != null) {
            throw new ParseException(String.format(DUPLICATE_ENTRANCE_TEMPLATE, new Object[]{Argument.MINVALUE, this.getName()}));
        }
    }

    void maxValue(Long maxValue) throws ParseException {
        if (this.arguments.containsKey((Object)Argument.MINVALUE) && (Long)this.arguments.get((Object)Argument.MINVALUE) >= maxValue) {
            throw new ParseException(String.format("MAXVALUE for sequence %s must be greater than MINVALUE", this.getName()));
        }
        if (this.arguments.putIfAbsent(Argument.MAXVALUE, maxValue) != null) {
            throw new ParseException(String.format(DUPLICATE_ENTRANCE_TEMPLATE, new Object[]{Argument.MINVALUE, this.getName()}));
        }
    }

    void setIsCycle(Boolean isCycle) throws ParseException {
        if (this.arguments.putIfAbsent(Argument.CYCLE, isCycle) != null) {
            throw new ParseException(String.format(DUPLICATE_ENTRANCE_TEMPLATE, new Object[]{Argument.CYCLE, this.getName()}));
        }
    }

    void finalizeParsing() throws ParseException {
        this.arguments.putIfAbsent(Argument.START_WITH, 1L);
        this.arguments.putIfAbsent(Argument.INCREMENT_BY, 1L);
        Long startWith = (Long)this.getArgument(Argument.START_WITH);
        Long incrementBy = (Long)this.getArgument(Argument.INCREMENT_BY);
        if (!this.hasArgument(Argument.MINVALUE)) {
            this.minValue(startWith);
        }
        Long minValue = (Long)this.getArgument(Argument.MINVALUE);
        if (startWith < minValue) {
            throw new ParseException(String.format("MINVALUE for sequence %s can't be greater than START WITH", this.getName()));
        }
        if (!this.hasArgument(Argument.MAXVALUE)) {
            this.maxValue(Long.MAX_VALUE);
        }
        Long maxValue = (Long)this.getArgument(Argument.MAXVALUE);
        if (startWith > maxValue) {
            throw new ParseException(String.format("MAXVALUE for sequence %s must be greater or equals START WITH", this.getName()));
        }
        if (!this.hasArgument(Argument.CYCLE)) {
            this.setIsCycle(false);
        }
        if (incrementBy < 0L) {
            if (startWith > 0L && startWith + incrementBy < minValue) {
                throw new ParseException(String.format("Sum of arguments START WITH AND INCREMENT BY must be greater or equals MINVALUE for sequence %s  in case of descending increment", this.getName()));
            }
            if (Math.abs(incrementBy) >= Math.abs(maxValue - minValue)) {
                throw new ParseException(String.format("Absolute value of 'INCREMENT BY' must be less than absolute value of subtraction of MAXVALUE and MINVALUE for sequence %s in case of descending increment", this.getName()));
            }
        }
    }

    public Map<Argument, Object> getArguments() {
        return this.arguments;
    }

    public boolean hasArgument(Argument argument) {
        return this.arguments.containsKey((Object)argument);
    }

    public Object getArgument(Argument argument) {
        return this.arguments.get((Object)argument);
    }

    public static enum Argument {
        START_WITH("START WITH", "START WITH %s "),
        INCREMENT_BY("INCREMENT BY", "INCREMENT BY %s "),
        MINVALUE("MINVALUE", "MINVALUE %s "),
        MAXVALUE("MAXVALUE", "MAXVALUE %s "),
        CYCLE("CYCLE", "CYCLE ");

        private final String type;
        private final String sqlTemplate;

        private Argument(String type, String sqlTemplate) {
            this.type = type;
            this.sqlTemplate = sqlTemplate;
        }

        public String getSql(Object value) {
            if (this == CYCLE && Objects.equals(false, value)) {
                return "";
            }
            return String.format(this.sqlTemplate, value);
        }

        public String toString() {
            return this.type;
        }
    }
}

