/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.celesta.score.discovery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.curs.celesta.CelestaException;
import ru.curs.celesta.score.Namespace;
import ru.curs.celesta.score.discovery.ScoreDiscovery;
import ru.curs.celesta.score.io.Resource;
import ru.curs.celesta.score.io.UrlResource;

public final class ScoreByScoreResourceDiscovery
implements ScoreDiscovery {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScoreByScoreResourceDiscovery.class);
    private static final String SCORE_FILES_LOCATION = "score/score.files";

    @Override
    public Set<Resource> discoverScore() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> urls = classLoader != null ? classLoader.getResources(SCORE_FILES_LOCATION) : ClassLoader.getSystemResources(SCORE_FILES_LOCATION);
            return this.discoverScore(urls);
        }
        catch (IOException ex) {
            throw new CelestaException("Unable to load score files from resources.", ex);
        }
    }

    Set<Resource> discoverScore(Enumeration<URL> scoreFilesUrls) throws IOException {
        LinkedHashMap<String, Resource> grainNameToResourceMap = new LinkedHashMap<String, Resource>();
        while (scoreFilesUrls.hasMoreElements()) {
            InputStream scoreFilesInputStream;
            UrlResource scoreFilesResource = new UrlResource(scoreFilesUrls.nextElement());
            try {
                scoreFilesInputStream = scoreFilesResource.getInputStream();
            }
            catch (IOException ex) {
                LOGGER.warn("score index file is missing: {}", (Object)scoreFilesResource);
                continue;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(scoreFilesInputStream, StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                String gp;
                while ((gp = reader.readLine()) != null) {
                    Resource grainResource;
                    String grainName = this.getGrainName(gp);
                    Resource existingGrainResource = grainNameToResourceMap.put(grainName, grainResource = scoreFilesResource.createRelative(gp, this.getGrainNamespace(gp)));
                    if (existingGrainResource == null) continue;
                    throw new CelestaException("Duplicate resources encountered for the grain '%s': %s, %s", grainName, existingGrainResource, grainResource);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        return new LinkedHashSet<Resource>(grainNameToResourceMap.values());
    }

    String getGrainName(String grainPath) {
        String result = grainPath.toLowerCase();
        int i = result.lastIndexOf(47);
        if (i >= 0) {
            result = result.substring(i + 1);
        }
        if ((i = result.lastIndexOf(46)) >= 0) {
            result = result.substring(0, i);
        }
        return result;
    }

    Namespace getGrainNamespace(String grainPath) {
        String[] parts = grainPath.split("/");
        return Arrays.stream(parts, 0, parts.length - 1).map(String::toLowerCase).reduce((ns1, ns2) -> ns1 + "." + ns2).map(Namespace::new).orElse(Namespace.DEFAULT);
    }
}

