/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.commons.profiler.impl;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxThroughputCalculator {
    private static final Logger log = LoggerFactory.getLogger(MaxThroughputCalculator.class);
    private final AtomicLong maxCallCountPerSecond = new AtomicLong();
    private final AtomicLong callCount = new AtomicLong();
    private final AtomicLong timeBeginningOfSecond = new AtomicLong();
    private static final long ONE_SECOND_MS = 1000L;

    public void call() {
        this.call(1L);
    }

    public void call(long eventCount) {
        long count = this.callCount.getAndAdd(eventCount);
        long time = this.timeBeginningOfSecond.get();
        long now = this.currentTimeMillis();
        log.trace("begin time {}, count {}, now {}", new Object[]{time, count, now});
        if (time + 1000L <= now && this.timeBeginningOfSecond.compareAndSet(time, now)) {
            long max;
            boolean doWhile;
            this.callCount.addAndGet(-count);
            do {
                max = this.maxCallCountPerSecond.get();
                log.trace("update max, count {}, max {}", (Object)count, (Object)max);
            } while (doWhile = count > max && !this.maxCallCountPerSecond.compareAndSet(max, count));
        }
    }

    long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public long getMaxAndReset() {
        log.trace("reset");
        this.call(0L);
        return this.maxCallCountPerSecond.getAndSet(0L);
    }

    public void reset() {
        this.getMaxAndReset();
    }
}

