/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.commons.profiler.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.fix.commons.profiler.ProfiledCall;
import ru.fix.commons.profiler.impl.SimpleProfiler;

class ProfiledCallImpl
implements ProfiledCall {
    private static final Logger log = LoggerFactory.getLogger(ProfiledCallImpl.class);
    final AtomicBoolean started = new AtomicBoolean();
    final AtomicLong startTime = new AtomicLong();
    final SimpleProfiler profiler;
    final String profiledCallName;

    ProfiledCallImpl(SimpleProfiler profiler, String profiledCallName) {
        this.profiler = profiler;
        this.profiledCallName = profiledCallName;
    }

    @Override
    public void call() {
        this.profiler.applyToSharedCounters(this.profiledCallName, sharedCounters -> {
            sharedCounters.getCallsCount().increment();
            sharedCounters.getMaxThroughput().call();
        });
    }

    @Override
    public ProfiledCall start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalArgumentException("Start method was already called.");
        }
        this.startTime.set(System.nanoTime());
        this.profiler.applyToSharedCounters(this.profiledCallName, sharedCounters -> {
            sharedCounters.getStartedCallsCount().increment();
            sharedCounters.getActiveCalls().add(this);
            sharedCounters.getActiveCallsCounter().increment();
        });
        return this;
    }

    @Override
    public void stop() {
        this.stop(1L);
    }

    @Override
    public void stop(long payload) {
        if (!this.started.compareAndSet(true, false)) {
            log.debug("Stop method called on profiler call that currently is not running: {}", (Object)this.profiledCallName);
            return;
        }
        long latencyValue = this.timeFromCallStartInMs();
        this.profiler.applyToSharedCounters(this.profiledCallName, sharedCounters -> {
            sharedCounters.getCallsCount().increment();
            sharedCounters.getSumStartStopLatency().add(latencyValue);
            sharedCounters.getLatencyMin().accumulateAndGet(latencyValue, Math::min);
            sharedCounters.getLatencyMax().accumulateAndGet(latencyValue, Math::max);
            sharedCounters.getPayloadMin().accumulateAndGet(payload, Math::min);
            sharedCounters.getPayloadMax().accumulateAndGet(payload, Math::max);
            sharedCounters.getPayloadSum().add(payload);
            sharedCounters.getMaxThroughput().call();
            sharedCounters.getMaxPayloadThroughput().call(payload);
            sharedCounters.getActiveCalls().remove(this);
            sharedCounters.getActiveCallsCounter().decrement();
        });
    }

    Long startTime() {
        return this.startTime.get();
    }

    long timeFromCallStartInMs() {
        return (System.nanoTime() - this.startTime.get()) / 1000000L;
    }

    @Override
    public void cancel() {
        if (!this.started.compareAndSet(true, false)) {
            log.debug("Cancel method called on profiler call that currently is not running: {}", (Object)this.profiledCallName);
            return;
        }
        this.profiler.applyToSharedCounters(this.profiledCallName, sharedCounters -> {
            sharedCounters.getActiveCalls().remove(this);
            sharedCounters.getActiveCallsCounter().decrement();
        });
    }

    @Override
    public boolean isStopped() {
        return !this.started.get();
    }
}

