/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.commons.profiler.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.fix.commons.profiler.IndicationProvider;
import ru.fix.commons.profiler.ProfilerCallReport;
import ru.fix.commons.profiler.ProfilerReport;
import ru.fix.commons.profiler.ProfilerReporter;
import ru.fix.commons.profiler.impl.ProfiledCallImpl;
import ru.fix.commons.profiler.impl.SharedCounters;
import ru.fix.commons.profiler.impl.SimpleProfiler;

class ProfilerReporterImpl
implements ProfilerReporter {
    private static final Logger log = LoggerFactory.getLogger(ProfilerReporterImpl.class);
    private final Map<String, SharedCounters> sharedCounters = new ConcurrentHashMap<String, SharedCounters>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final SimpleProfiler profiler;
    private final AtomicLong lastReportTimestamp;
    private final AtomicBoolean enableActiveCallsMaxLatency;
    private final AtomicInteger numberOfActiveCallsToKeepBetweenReports;

    public ProfilerReporterImpl(SimpleProfiler profiler) {
        this(profiler, false, 20);
    }

    public ProfilerReporterImpl(SimpleProfiler profiler, boolean enableActiveCallsMaxLatency, int numberOfActiveCallsToKeepBetweenReports) {
        this.profiler = profiler;
        this.profiler.registerReporter(this);
        this.enableActiveCallsMaxLatency = new AtomicBoolean(enableActiveCallsMaxLatency);
        this.numberOfActiveCallsToKeepBetweenReports = new AtomicInteger(numberOfActiveCallsToKeepBetweenReports);
        this.lastReportTimestamp = new AtomicLong(System.currentTimeMillis());
    }

    @Override
    public boolean setEnableActiveCallsMaxLatency(boolean enable) {
        boolean prevValue = this.enableActiveCallsMaxLatency.getAndSet(enable);
        this.sharedCounters.values().forEach(counters -> counters.setRecordActiveCalls(enable));
        return prevValue;
    }

    @Override
    public int setNumberOfActiveCallsToKeepBetweenReports(int number) {
        return this.numberOfActiveCallsToKeepBetweenReports.getAndSet(number);
    }

    public void applyToSharedCounters(String profiledCallName, Consumer<SharedCounters> consumer) {
        this.readLock.lock();
        try {
            consumer.accept(this.sharedCounters.computeIfAbsent(profiledCallName, key -> new SharedCounters(this.enableActiveCallsMaxLatency.get())));
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfilerReport buildReportAndReset() {
        long timestamp = System.currentTimeMillis();
        long spentTime = timestamp - this.lastReportTimestamp.getAndSet(timestamp);
        ProfilerReport report = new ProfilerReport();
        report.setIndicators(this.profiler.getIndicators().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            try {
                return ((IndicationProvider)e.getValue()).get();
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                return null;
            }
        })));
        ArrayList<ProfilerCallReport> collect = new ArrayList<ProfilerCallReport>();
        this.writeLock.lock();
        try {
            Iterator<Map.Entry<String, SharedCounters>> iterator = this.sharedCounters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, SharedCounters> entry = iterator.next();
                ProfilerCallReport counterReport = this.buildReportAndReset(entry.getKey(), entry.getValue(), spentTime);
                if (counterReport.getCallsCount() == 0L && counterReport.getActiveCallsCount() == 0L) {
                    iterator.remove();
                    continue;
                }
                collect.add(counterReport);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        collect.sort(Comparator.comparing(ProfilerCallReport::getName));
        report.setProfilerCallReports(collect);
        return report;
    }

    private ProfilerCallReport buildReportAndReset(String name, SharedCounters counters, long elapsed) {
        long callsCount = counters.getCallsCount().sumThenReset();
        long startedCallsCount = counters.getStartedCallsCount().sumThenReset();
        long sumStartStopLatency = counters.getSumStartStopLatency().sumThenReset();
        if (callsCount == 0L) {
            this.cleanCounters(counters);
            return new ProfilerCallReport(name).setStartedCallsCount(startedCallsCount).setActiveCallsCount(counters.getActiveCallsCounter().sum()).setActiveCallsMaxLatency(this.activeCallsMaxLatencyAndResetActiveCalls(counters));
        }
        long payloadTotal = counters.getPayloadSum().sumThenReset();
        return new ProfilerCallReport(name).setMinLatency(counters.getLatencyMin().getAndSet(Long.MAX_VALUE)).setMaxLatency(counters.getLatencyMax().getAndSet(0L)).setAvgLatency(sumStartStopLatency / callsCount).setCallsThroughput(elapsed != 0L ? callsCount * 1000L / elapsed : 0L).setCallsCount(callsCount).setStartedCallsCount(startedCallsCount).setPayloadMin(counters.getPayloadMin().getAndSet(Long.MAX_VALUE)).setPayloadMax(counters.getPayloadMax().getAndSet(0L)).setPayloadTotal(payloadTotal).setPayloadAvg(payloadTotal / callsCount).setPayloadThroughput(elapsed != 0L ? payloadTotal * 1000L / elapsed : 0L).setReportingTime(elapsed).setMaxThroughputPerSecond(counters.getMaxThroughput().getMaxAndReset()).setMaxPayloadThroughputPerSecond(counters.getMaxPayloadThroughput().getMaxAndReset()).setActiveCallsCount(counters.getActiveCallsCounter().sum()).setActiveCallsMaxLatency(this.activeCallsMaxLatencyAndResetActiveCalls(counters));
    }

    private long activeCallsMaxLatencyAndResetActiveCalls(SharedCounters counters) {
        Optional<ProfiledCallImpl> longestCall = this.resetActiveCallsAndGetLongest(counters);
        return longestCall.map(ProfiledCallImpl::timeFromCallStartInMs).orElse(0L);
    }

    private Optional<ProfiledCallImpl> resetActiveCallsAndGetLongest(SharedCounters counters) {
        if (!this.enableActiveCallsMaxLatency.get() && !counters.getActiveCalls().isEmpty()) {
            counters.getActiveCalls().reset();
            return Optional.empty();
        }
        ProfiledCallImpl[] longest = new ProfiledCallImpl[1];
        HashSet top = new HashSet();
        counters.getActiveCalls().stream().sorted(Comparator.comparingLong(ProfiledCallImpl::startTime)).limit(this.numberOfActiveCallsToKeepBetweenReports.get()).forEachOrdered(call -> {
            if (top.isEmpty()) {
                longest[0] = call;
            }
            top.add(call);
        });
        Iterator<ProfiledCallImpl> calls = counters.getActiveCalls().iterator();
        while (calls.hasNext()) {
            ProfiledCallImpl call2 = calls.next();
            if (top.contains(call2)) continue;
            calls.remove();
        }
        return Optional.ofNullable(longest[0]);
    }

    private void cleanCounters(SharedCounters counters) {
        counters.getCallsCount().reset();
        counters.getLatencyMax().set(0L);
        counters.getLatencyMin().set(Long.MAX_VALUE);
        counters.getSumStartStopLatency().reset();
        counters.getPayloadSum().reset();
        counters.getPayloadMax().set(0L);
        counters.getPayloadMin().set(Long.MAX_VALUE);
        counters.getMaxThroughput().reset();
        counters.getMaxPayloadThroughput().reset();
    }

    @Override
    public void close() {
        this.profiler.unregisterReporter(this);
    }
}

