/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.commons.profiler.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import ru.fix.commons.profiler.impl.MaxThroughputCalculator;
import ru.fix.commons.profiler.impl.ProfiledCallImpl;

class SharedCounters {
    private final LongAdder callsCount = new LongAdder();
    private final LongAdder startedCallsCount = new LongAdder();
    private final LongAdder sumStartStopLatency = new LongAdder();
    private final AtomicLong latencyMin = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong latencyMax = new AtomicLong();
    private final AtomicLong payloadMin = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong payloadMax = new AtomicLong();
    private final LongAdder payloadSum = new LongAdder();
    private final MaxThroughputCalculator maxThroughput = new MaxThroughputCalculator();
    private final MaxThroughputCalculator maxPayloadThroughput = new MaxThroughputCalculator();
    private final LongAdder activeCallsCounter = new LongAdder();
    private final ActiveCallsSet activeCalls = new ActiveCallsSet();
    private final AtomicBoolean recordActiveCalls = new AtomicBoolean();

    public SharedCounters(boolean recordActiveCalls) {
        this.recordActiveCalls.set(recordActiveCalls);
    }

    void setRecordActiveCalls(boolean recordActiveCalls) {
        this.recordActiveCalls.set(recordActiveCalls);
    }

    public LongAdder getCallsCount() {
        return this.callsCount;
    }

    public LongAdder getStartedCallsCount() {
        return this.startedCallsCount;
    }

    public LongAdder getSumStartStopLatency() {
        return this.sumStartStopLatency;
    }

    public AtomicLong getLatencyMin() {
        return this.latencyMin;
    }

    public AtomicLong getLatencyMax() {
        return this.latencyMax;
    }

    public AtomicLong getPayloadMin() {
        return this.payloadMin;
    }

    public AtomicLong getPayloadMax() {
        return this.payloadMax;
    }

    public LongAdder getPayloadSum() {
        return this.payloadSum;
    }

    public MaxThroughputCalculator getMaxThroughput() {
        return this.maxThroughput;
    }

    public MaxThroughputCalculator getMaxPayloadThroughput() {
        return this.maxPayloadThroughput;
    }

    public LongAdder getActiveCallsCounter() {
        return this.activeCallsCounter;
    }

    public ActiveCallsSet getActiveCalls() {
        return this.activeCalls;
    }

    public class ActiveCallsSet
    implements Iterable<ProfiledCallImpl> {
        private ConcurrentHashMap<ProfiledCallImpl, Boolean> activeCalls = new ConcurrentHashMap();

        public void add(ProfiledCallImpl call) {
            if (SharedCounters.this.recordActiveCalls.get()) {
                this.activeCalls.put(call, true);
            }
        }

        public void remove(ProfiledCallImpl call) {
            this.activeCalls.remove(call);
        }

        public boolean isEmpty() {
            return this.activeCalls.isEmpty();
        }

        public int size() {
            return this.activeCalls.size();
        }

        public boolean containsAll(Collection<?> collection) {
            return ((ConcurrentHashMap.CollectionView)((Object)this.activeCalls.keySet())).containsAll(collection);
        }

        @Override
        public Iterator<ProfiledCallImpl> iterator() {
            return ((ConcurrentHashMap.KeySetView)this.activeCalls.keySet()).iterator();
        }

        public Stream<ProfiledCallImpl> stream() {
            return this.activeCalls.keySet().stream();
        }

        public void reset() {
            this.activeCalls.clear();
        }
    }
}

