/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.commons.profiler.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import ru.fix.commons.profiler.IndicationProvider;
import ru.fix.commons.profiler.ProfiledCall;
import ru.fix.commons.profiler.Profiler;
import ru.fix.commons.profiler.ProfilerReporter;
import ru.fix.commons.profiler.impl.ProfiledCallImpl;
import ru.fix.commons.profiler.impl.ProfilerReporterImpl;
import ru.fix.commons.profiler.impl.SharedCounters;

public class SimpleProfiler
implements Profiler {
    private final CopyOnWriteArrayList<ProfilerReporterImpl> profilerReporters = new CopyOnWriteArrayList();
    private final Map<String, IndicationProvider> indicators = new ConcurrentHashMap<String, IndicationProvider>();

    @Override
    public ProfiledCall profiledCall(String name) {
        return new ProfiledCallImpl(this, name);
    }

    public SimpleProfiler registerReporter(ProfilerReporterImpl reporter) {
        this.profilerReporters.add(reporter);
        return this;
    }

    public SimpleProfiler unregisterReporter(ProfilerReporterImpl reporter) {
        this.profilerReporters.remove(reporter);
        return this;
    }

    @Override
    public void attachIndicator(String name, IndicationProvider indicationProvider) {
        this.indicators.put(name, indicationProvider);
    }

    @Override
    public void detachIndicator(String name) {
        this.indicators.remove(name);
    }

    void applyToSharedCounters(String profiledCallName, Consumer<SharedCounters> consumer) {
        this.profilerReporters.forEach(reporter -> reporter.applyToSharedCounters(profiledCallName, consumer));
    }

    Map<String, IndicationProvider> getIndicators() {
        return this.indicators;
    }

    @Override
    public ProfilerReporter createReporter() {
        return new ProfilerReporterImpl(this);
    }

    @Override
    public ProfilerReporter createReporter(boolean enableActiveCallsMaxLatency, int activeCallsToKeepBetweenReports) {
        return new ProfilerReporterImpl(this, enableActiveCallsMaxLatency, activeCallsToKeepBetweenReports);
    }
}

