/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.dynamic.property.zk;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorEvent;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.logging.log4j.kotlin.KotlinLogger;
import org.apache.logging.log4j.kotlin.Logging;
import org.apache.zookeeper.data.Stat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.fix.dynamic.property.api.marshaller.DynamicPropertyMarshaller;
import ru.fix.dynamic.property.std.source.AbstractPropertySource;
import ru.fix.dynamic.property.zk.ZkDynamicPropertySource$WhenMappings;
import ru.fix.stdlib.concurrency.threads.ReferenceCleaner;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u001a\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001c0\u001bJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lru/fix/dynamic/property/zk/ZkDynamicPropertySource;", "Lru/fix/dynamic/property/std/source/AbstractPropertySource;", "curatorFramework", "Lorg/apache/curator/framework/CuratorFramework;", "zookeeperConfigPath", "", "marshaller", "Lru/fix/dynamic/property/api/marshaller/DynamicPropertyMarshaller;", "initializationTimeout", "Ljava/time/Duration;", "(Lorg/apache/curator/framework/CuratorFramework;Ljava/lang/String;Lru/fix/dynamic/property/api/marshaller/DynamicPropertyMarshaller;Ljava/time/Duration;)V", "rootPath", "rootPathPrefix", "treeCache", "Lorg/apache/curator/framework/recipes/cache/TreeCache;", "close", "", "getAbsolutePathForProperty", "propertyName", "getPropertyNameFromAbsolutePath", "absolutePath", "getPropertyValue", "onZkTreeChanged", "treeCacheEvent", "Lorg/apache/curator/framework/recipes/cache/TreeCacheEvent;", "newValue", "readAllProperties", "", "", "zkDataToStringOrNull", "data", "", "logDetails", "Companion", "dynamic-property-zk"})
public final class ZkDynamicPropertySource
extends AbstractPropertySource {
    private final TreeCache treeCache;
    private final String rootPath;
    private final String rootPathPrefix;
    private final CuratorFramework curatorFramework;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, Object> readAllProperties() {
        List childs;
        HashMap allProperties = new HashMap();
        Stat exist = (Stat)this.curatorFramework.checkExists().forPath(this.rootPath);
        if (exist != null && !(childs = (List)this.curatorFramework.getChildren().forPath(this.rootPath)).isEmpty()) {
            CountDownLatch latch = new CountDownLatch(childs.size());
            for (String child : childs) {
                ErrorListenerPathable errorListenerPathable = (ErrorListenerPathable)((BackgroundPathable)this.curatorFramework.getData().watched()).inBackground(new BackgroundCallback(allProperties, child, latch){
                    final /* synthetic */ HashMap $allProperties;
                    final /* synthetic */ String $child;
                    final /* synthetic */ CountDownLatch $latch;

                    public final void processResult(CuratorFramework client, CuratorEvent event) {
                        Map map = this.$allProperties;
                        String string = this.$child;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"child");
                        CuratorEvent curatorEvent = event;
                        Intrinsics.checkExpressionValueIsNotNull((Object)curatorEvent, (String)"event");
                        byte[] byArray = curatorEvent.getData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"event.data");
                        byte[] byArray2 = byArray;
                        Charset charset = StandardCharsets.UTF_8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                        Charset charset2 = charset;
                        String string2 = string;
                        Map map2 = map;
                        String string3 = new String(byArray2, charset2);
                        map2.put(string2, string3);
                        this.$latch.countDown();
                    }
                    {
                        this.$allProperties = hashMap;
                        this.$child = string;
                        this.$latch = countDownLatch;
                    }
                });
                String string = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"child");
                errorListenerPathable.forPath(this.getAbsolutePathForProperty(string));
            }
            if (!latch.await(120L, TimeUnit.SECONDS)) {
                throw (Throwable)new TimeoutException("Failed to extract zk properties data");
            }
        }
        return allProperties;
    }

    private final String zkDataToStringOrNull(byte[] data, String logDetails) {
        Object object;
        try {
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            object = charset;
            object = new String(data, (Charset)object);
        }
        catch (Exception exc) {
            Companion.getLogger().error((CharSequence)("Failed to read string value from zk node. " + logDetails), (Throwable)exc);
            object = null;
        }
        return object;
    }

    private final void onZkTreeChanged(TreeCacheEvent treeCacheEvent, String newValue) {
        String absolutePath;
        ChildData childData = treeCacheEvent.getData();
        Intrinsics.checkExpressionValueIsNotNull((Object)childData, (String)"treeCacheEvent.data");
        String string = absolutePath = childData.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"absolutePath");
        if (!StringsKt.startsWith$default((String)string, (String)this.rootPathPrefix, (boolean)false, (int)2, null)) {
            return;
        }
        String propertyName = this.getPropertyNameFromAbsolutePath(absolutePath);
        Companion.getLogger().info((CharSequence)("Zk property change: type: " + treeCacheEvent.getType() + ", node: " + absolutePath + ". New value is '" + newValue + '\''));
        this.invokePropertyListener(propertyName, newValue);
    }

    @Nullable
    protected String getPropertyValue(@NotNull String propertyName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        String path = this.getAbsolutePathForProperty(propertyName);
        ChildData currentData = this.treeCache.getCurrentData(path);
        if (currentData == null) {
            string = null;
        } else {
            byte[] byArray = currentData.getData();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"currentData.data");
            String string2 = currentData.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"currentData.toString()");
            string = this.zkDataToStringOrNull(byArray, string2);
        }
        return string;
    }

    private final String getAbsolutePathForProperty(String propertyName) {
        Objects.requireNonNull(propertyName);
        return this.rootPath + '/' + propertyName;
    }

    private final String getPropertyNameFromAbsolutePath(String absolutePath) {
        String string = absolutePath;
        int n = this.rootPath.length() + 1;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        return string3;
    }

    public void close() {
        super.close();
        this.treeCache.close();
    }

    public ZkDynamicPropertySource(@NotNull CuratorFramework curatorFramework, @NotNull String zookeeperConfigPath, @NotNull DynamicPropertyMarshaller marshaller, @NotNull Duration initializationTimeout) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)curatorFramework, (String)"curatorFramework");
        Intrinsics.checkParameterIsNotNull((Object)zookeeperConfigPath, (String)"zookeeperConfigPath");
        Intrinsics.checkParameterIsNotNull((Object)marshaller, (String)"marshaller");
        Intrinsics.checkParameterIsNotNull((Object)initializationTimeout, (String)"initializationTimeout");
        ReferenceCleaner referenceCleaner = ReferenceCleaner.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)referenceCleaner, (String)"ReferenceCleaner.getInstance()");
        super(marshaller, referenceCleaner);
        this.curatorFramework = curatorFramework;
        ZkDynamicPropertySource zkDynamicPropertySource = this;
        if (StringsKt.endsWith$default((CharSequence)zookeeperConfigPath, (char)'/', (boolean)false, (int)2, null)) {
            String string2 = zookeeperConfigPath;
            int n = 0;
            int n2 = zookeeperConfigPath.length() - 1;
            ZkDynamicPropertySource zkDynamicPropertySource2 = zkDynamicPropertySource;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string4 = string3;
            zkDynamicPropertySource = zkDynamicPropertySource2;
            string = string4;
        } else {
            string = zookeeperConfigPath;
        }
        zkDynamicPropertySource.rootPath = string;
        this.rootPathPrefix = this.rootPath + '/';
        if (this.curatorFramework.getState() == CuratorFrameworkState.LATENT) {
            this.curatorFramework.start();
        }
        this.treeCache = new TreeCache(this.curatorFramework, this.rootPath);
        final CountDownLatch treeCacheInitialized = new CountDownLatch(1);
        this.treeCache.getListenable().addListener((Object)new TreeCacheListener(){

            public final void childEvent(CuratorFramework currentFramework, TreeCacheEvent treeCacheEvent) {
                Companion.getLogger().trace((CharSequence)("Received TreeCache event: " + treeCacheEvent));
                TreeCacheEvent treeCacheEvent2 = treeCacheEvent;
                Intrinsics.checkExpressionValueIsNotNull((Object)treeCacheEvent2, (String)"treeCacheEvent");
                TreeCacheEvent.Type type = treeCacheEvent2.getType();
                if (type != null) {
                    switch (ZkDynamicPropertySource$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: 
                        case 2: {
                            try {
                                byte[] byArray = treeCacheEvent.getData().getData();
                                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"treeCacheEvent.getData().getData()");
                                String string = treeCacheEvent.toString();
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"treeCacheEvent.toString()");
                                this.onZkTreeChanged(treeCacheEvent, this.zkDataToStringOrNull(byArray, string));
                            }
                            catch (Exception exc) {
                                Companion.getLogger().error((CharSequence)("Zk property updating error for event " + treeCacheEvent), (Throwable)exc);
                            }
                            break;
                        }
                        case 3: {
                            this.onZkTreeChanged(treeCacheEvent, null);
                            break;
                        }
                        case 4: {
                            treeCacheInitialized.countDown();
                        }
                    }
                }
            }
        });
        this.treeCache.start();
        treeCacheInitialized.await(initializationTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/fix/dynamic/property/zk/ZkDynamicPropertySource$Companion;", "Lorg/apache/logging/log4j/kotlin/Logging;", "()V", "dynamic-property-zk"})
    public static final class Companion
    implements Logging {
        private Companion() {
        }

        @NotNull
        public KotlinLogger getLogger() {
            return Logging.DefaultImpls.getLogger((Logging)this);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

