/*
 * Decompiled with CFR 0.152.
 */
package ru.makkarpov.scalingua.pofile.shaded_javacup;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.makkarpov.scalingua.pofile.shaded_javacup.Symbol;
import ru.makkarpov.scalingua.pofile.shaded_javacup.SymbolFactory;

public class ComplexSymbolFactory
implements SymbolFactory {
    public Symbol newSymbol(String name, int id, Location left, Location right, Object value) {
        return new ComplexSymbol(name, id, left, right, value);
    }

    public Symbol newSymbol(String name, int id, Location left, Location right) {
        return new ComplexSymbol(name, id, left, right);
    }

    @Override
    public Symbol newSymbol(String name, int id, Symbol left, Object value) {
        return new ComplexSymbol(name, id, left, value);
    }

    @Override
    public Symbol newSymbol(String name, int id, Symbol left, Symbol right, Object value) {
        return new ComplexSymbol(name, id, left, right, value);
    }

    @Override
    public Symbol newSymbol(String name, int id, Symbol left, Symbol right) {
        return new ComplexSymbol(name, id, left, right);
    }

    @Override
    public Symbol newSymbol(String name, int id) {
        return new ComplexSymbol(name, id);
    }

    @Override
    public Symbol newSymbol(String name, int id, Object value) {
        return new ComplexSymbol(name, id, value);
    }

    @Override
    public Symbol startSymbol(String name, int id, int state) {
        return new ComplexSymbol(name, id, state);
    }

    public static class ComplexSymbol
    extends Symbol {
        protected String name;
        public Location xleft;
        public Location xright;

        public ComplexSymbol(String name, int id) {
            super(id);
            this.name = name;
        }

        public ComplexSymbol(String name, int id, Object value) {
            super(id, value);
            this.name = name;
        }

        @Override
        public String toString() {
            if (this.xleft == null || this.xright == null) {
                return "Symbol: " + this.name;
            }
            return "Symbol: " + this.name + " (" + this.xleft + " - " + this.xright + ")";
        }

        public String getName() {
            return this.name;
        }

        public ComplexSymbol(String name, int id, int state) {
            super(id, state);
            this.name = name;
        }

        public ComplexSymbol(String name, int id, Symbol left, Symbol right) {
            super(id, left, right);
            this.name = name;
            if (left != null) {
                this.xleft = ((ComplexSymbol)left).xleft;
            }
            if (right != null) {
                this.xright = ((ComplexSymbol)right).xright;
            }
        }

        public ComplexSymbol(String name, int id, Location left, Location right) {
            super(id, left.offset, right.offset);
            this.name = name;
            this.xleft = left;
            this.xright = right;
        }

        public ComplexSymbol(String name, int id, Symbol left, Symbol right, Object value) {
            super(id, left.left, right.right, value);
            this.name = name;
            if (left != null) {
                this.xleft = ((ComplexSymbol)left).xleft;
            }
            if (right != null) {
                this.xright = ((ComplexSymbol)right).xright;
            }
        }

        public ComplexSymbol(String name, int id, Symbol left, Object value) {
            super(id, left.right, left.right, value);
            this.name = name;
            if (left != null) {
                this.xleft = ((ComplexSymbol)left).xright;
                this.xright = ((ComplexSymbol)left).xright;
            }
        }

        public ComplexSymbol(String name, int id, Location left, Location right, Object value) {
            super(id, left.offset, right.offset, value);
            this.name = name;
            this.xleft = left;
            this.xright = right;
        }

        public Location getLeft() {
            return this.xleft;
        }

        public Location getRight() {
            return this.xright;
        }
    }

    public static class Location {
        private String unit = "unknown";
        private int line;
        private int column;
        private int offset = -1;

        public Location(Location other) {
            this(other.unit, other.line, other.column, other.offset);
        }

        public Location(String unit, int line, int column, int offset) {
            this(unit, line, column);
            this.offset = offset;
        }

        public Location(String unit, int line, int column) {
            this.unit = unit;
            this.line = line;
            this.column = column;
        }

        public Location(int line, int column, int offset) {
            this(line, column);
            this.offset = offset;
        }

        public Location(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getColumn() {
            return this.column;
        }

        public int getLine() {
            return this.line;
        }

        public void move(int linediff, int coldiff, int offsetdiff) {
            if (this.line >= 0) {
                this.line += linediff;
            }
            if (this.column >= 0) {
                this.column += coldiff;
            }
            if (this.offset >= 0) {
                this.offset += offsetdiff;
            }
        }

        public static Location clone(Location other) {
            return new Location(other);
        }

        public String getUnit() {
            return this.unit;
        }

        public String toString() {
            return this.getUnit() + ":" + this.getLine() + "/" + this.getColumn() + "(" + this.offset + ")";
        }

        public void toXML(XMLStreamWriter writer, String orientation) throws XMLStreamException {
            writer.writeStartElement("location");
            writer.writeAttribute("compilationunit", this.unit);
            writer.writeAttribute("orientation", orientation);
            writer.writeAttribute("linenumber", this.line + "");
            writer.writeAttribute("columnnumber", this.column + "");
            writer.writeAttribute("offset", this.offset + "");
            writer.writeEndElement();
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

