/*
 * Decompiled with CFR 0.152.
 */
package ru.makkarpov.scalingua.pofile.shaded_javacup;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import ru.makkarpov.scalingua.pofile.shaded_javacup.XMLElement;

public class SyntaxTreeXPath {
    public static List<XMLElement> query(String query, XMLElement element) {
        if (query.startsWith("/")) {
            query = query.substring(1);
        }
        return SyntaxTreeXPath.query0(new LinkedList<String>(Arrays.asList(query.split("/"))), 0, element, 0);
    }

    private static List<XMLElement> query0(List<String> q, int idx, XMLElement element, int seq) {
        if (q.get(idx).isEmpty()) {
            return SyntaxTreeXPath.matchDeeperDescendant(q, idx + 1, element, seq);
        }
        LinkedList<XMLElement> l = new LinkedList<XMLElement>();
        if (!SyntaxTreeXPath.match(q.get(idx), element, seq)) {
            return new LinkedList<XMLElement>();
        }
        if (q.size() - 1 == idx) {
            return SyntaxTreeXPath.singleton(element);
        }
        List<XMLElement> children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = children.get(i);
            l.addAll(SyntaxTreeXPath.query0(q, idx + 1, child, i));
        }
        return l;
    }

    private static List<XMLElement> matchDeeperDescendant(List<String> query, int idx, XMLElement element, int seq) {
        if (query.size() <= idx) {
            return SyntaxTreeXPath.singleton(element);
        }
        boolean matches = SyntaxTreeXPath.match(query.get(idx), element, seq);
        LinkedList<XMLElement> l = new LinkedList<XMLElement>();
        List<XMLElement> children = element.getChildren();
        if (matches) {
            return SyntaxTreeXPath.query0(query, idx, element, seq);
        }
        for (int i = 0; i < children.size(); ++i) {
            XMLElement child = children.get(i);
            l.addAll(SyntaxTreeXPath.matchDeeperDescendant(query, idx, child, i));
        }
        return l;
    }

    private static boolean match(String m, XMLElement elem, int seq) {
        boolean result = true;
        String[] name = m.split("\\[");
        String[] tag = name[0].split("\\*");
        result = tag[0].isEmpty() ? (tag.length > 2 ? (result &= elem.tagname.contains(tag[1])) : (tag.length == 2 ? (result &= elem.tagname.endsWith(tag[1])) : (result &= false))) : (tag.length == 2 ? (result &= elem.tagname.startsWith(tag[1])) : elem.tagname.equals(tag[0]));
        for (int i = 1; i < name.length; ++i) {
            String predicate = name[i];
            if (!predicate.endsWith("]")) {
                return false;
            }
            if ((predicate = predicate.substring(0, predicate.length() - 1)).startsWith("@")) {
                if (predicate.substring(1).startsWith("variant")) {
                    if (elem instanceof XMLElement.NonTerminal && Integer.parseInt(predicate.substring(9)) == ((XMLElement.NonTerminal)elem).getVariant()) {
                        result &= true;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            if (predicate.matches("\\d+")) {
                result &= Integer.parseInt(predicate) == seq;
                continue;
            }
            return false;
        }
        return result;
    }

    private static List<XMLElement> singleton(XMLElement elem) {
        LinkedList<XMLElement> l = new LinkedList<XMLElement>();
        l.add(elem);
        return l;
    }
}

