/*
 * Decompiled with CFR 0.152.
 */
package ru.makkarpov.scalingua;

import java.io.Serializable;
import ru.makkarpov.scalingua.OutputFormat;
import ru.makkarpov.scalingua.StringUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class StringUtils$ {
    public static final StringUtils$ MODULE$ = new StringUtils$();
    private static final char VariableCharacter = (char)37;
    private static final Tuple2<Object, Object> VariableParentheses = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'(')), (Object)BoxesRunTime.boxToCharacter((char)')'));
    private static final String VariableStr = ((Object)BoxesRunTime.boxToCharacter((char)MODULE$.VariableCharacter())).toString();
    private static final String VariableEscapeStr = new java.lang.StringBuilder(0).append(MODULE$.VariableStr()).append(MODULE$.VariableStr()).toString();
    private static final String VariableStartStr = new java.lang.StringBuilder(0).append(MODULE$.VariableStr()).append(MODULE$.VariableParentheses()._1$mcC$sp()).toString();

    public char VariableCharacter() {
        return VariableCharacter;
    }

    public Tuple2<Object, Object> VariableParentheses() {
        return VariableParentheses;
    }

    public String VariableStr() {
        return VariableStr;
    }

    public String VariableEscapeStr() {
        return VariableEscapeStr;
    }

    public String VariableStartStr() {
        return VariableStartStr;
    }

    public String unescape(String s) {
        StringBuilder ret = new StringBuilder();
        ret.sizeHint(s.length());
        int cursor = 0;
        while (cursor < s.length()) {
            int n;
            int pos = s.indexOf(92, cursor);
            if (pos == -1) {
                ret.$plus$plus$eq(s.substring(cursor));
                cursor = Integer.MAX_VALUE;
                continue;
            }
            ret.$plus$plus$eq(s.substring(cursor, pos));
            if (pos + 1 >= s.length()) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(34).append("Unexpected end of string at index ").append(pos).toString());
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), pos + 1);
            switch (c) {
                case 'u': {
                    n = 4;
                    break;
                }
                case '\"': 
                case '\'': 
                case '\\': 
                case 'b': 
                case 'f': 
                case 'n': 
                case 'r': 
                case 't': {
                    n = 0;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(38).append("Invalid escape character '\\").append(c).append("' at index ").append(pos).toString());
                }
            }
            int escapeLength = n;
            if (pos + 1 + escapeLength >= s.length()) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(34).append("Unexpected end of string at index ").append(pos).toString());
            }
            char c2 = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), pos + 1);
            switch (c2) {
                case 'n': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                    break;
                }
                case 'r': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\r'));
                    break;
                }
                case 't': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\t'));
                    break;
                }
                case 'b': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\b'));
                    break;
                }
                case 'f': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\f'));
                    break;
                }
                case '\\': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\\'));
                    break;
                }
                case '\'': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\''));
                    break;
                }
                case '\"': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\"'));
                    break;
                }
                case 'u': {
                    Growable growable = ret.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)((char)Integer.parseInt(s.substring(pos + 2, pos + 6), 16))));
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToCharacter((char)c2));
                }
            }
            cursor = pos + 2 + escapeLength;
        }
        return ret.result();
    }

    public String escape(String s, boolean escapeUnicode) {
        StringBuilder ret = new StringBuilder();
        ret.sizeHint(s.length());
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)c -> StringUtils$.$anonfun$escape$1(ret, escapeUnicode, BoxesRunTime.unboxToChar((Object)c)));
        return ret.result();
    }

    public boolean escape$default$2() {
        return true;
    }

    public <R> R interpolate(String msg, Seq<Tuple2<String, Object>> args, OutputFormat<R> format) {
        StringBuilder result = new StringBuilder();
        int cursor = 0;
        while (cursor < msg.length()) {
            BoxedUnit boxedUnit;
            int pos = msg.indexOf(this.VariableCharacter(), cursor);
            if (pos == -1) {
                result.$plus$plus$eq(msg.substring(cursor));
                cursor = Integer.MAX_VALUE;
                continue;
            }
            result.$plus$plus$eq(msg.substring(cursor, pos));
            if (pos + 1 >= msg.length()) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(29).append("Stray '").append(this.VariableCharacter()).append("' at the end of string").toString());
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(msg), pos + 1);
            if (this.VariableCharacter() == c) {
                result.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)this.VariableCharacter()));
                cursor = pos + 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (this.VariableParentheses()._1$mcC$sp() == c) {
                int end = msg.indexOf(this.VariableParentheses()._2$mcC$sp(), pos + 2);
                if (end == -1) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(25).append("Unterminated variable at ").append(pos).toString());
                }
                String varName = msg.substring(pos + 2, end);
                if (varName.isEmpty()) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(23).append("Empty variable name at ").append(pos).toString());
                }
                int idx = 0;
                boolean found = false;
                while (idx < args.size()) {
                    Tuple2 v = (Tuple2)args.apply(idx);
                    ++idx;
                    Object object = v._1();
                    String string = varName;
                    if (object != null ? !object.equals(string) : string != null) continue;
                    result.$plus$plus$eq(format.escape(v._2().toString()));
                    found = true;
                    idx = Integer.MAX_VALUE;
                }
                if (!found) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(26).append("Undefined variable at ").append(pos).append(": '").append(varName).append("'").toString());
                }
                cursor = end + 1;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new StringUtils.InvalidInterpolationException(new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(42).append("Invalid interpolation character after '").append(this.VariableCharacter()).append("': ").toString()).append(new java.lang.StringBuilder(33).append("'").append(c).append("' (escape '").append(this.VariableCharacter()).append("' by typing it twice)").toString()).toString());
        }
        return format.convert(result.result());
    }

    public Set<String> extractVariables(String msg) {
        Builder result = Predef$.MODULE$.Set().newBuilder();
        int cursor = 0;
        while (cursor < msg.length()) {
            BoxedUnit boxedUnit;
            int pos = msg.indexOf(this.VariableCharacter(), cursor);
            if (pos == -1) {
                cursor = Integer.MAX_VALUE;
                continue;
            }
            if (pos + 1 >= msg.length()) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(29).append("Stray '").append(this.VariableCharacter()).append("' at the end of string").toString());
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(msg), pos + 1);
            if (this.VariableCharacter() == c) {
                cursor = pos + 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (this.VariableParentheses()._1$mcC$sp() == c) {
                int end = msg.indexOf(this.VariableParentheses()._2$mcC$sp(), pos + 2);
                if (end == -1) {
                    throw new IllegalArgumentException(new java.lang.StringBuilder(25).append("Unterminated variable at ").append(pos).toString());
                }
                String varName = msg.substring(pos + 2, end);
                if (varName.isEmpty()) {
                    throw new IllegalArgumentException("Empty variable name");
                }
                result.$plus$eq((Object)varName);
                cursor = end + 1;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new StringUtils.InvalidInterpolationException(new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(42).append("Invalid interpolation character after '").append(this.VariableCharacter()).append("': ").toString()).append(new java.lang.StringBuilder(33).append("'").append(c).append("' (escape '").append(this.VariableCharacter()).append("' by typing it twice)").toString()).toString());
        }
        return (Set)result.result();
    }

    public String escapeInterpolation(String s) {
        StringBuilder result = new StringBuilder();
        int cursor = 0;
        while (cursor < s.length()) {
            int pos = s.indexOf(this.VariableCharacter(), cursor);
            if (pos == -1) {
                result.$plus$plus$eq(s.substring(cursor));
                cursor = Integer.MAX_VALUE;
                continue;
            }
            result.$plus$plus$eq(s.substring(cursor, pos));
            result.$plus$plus$eq("%%");
            cursor = pos + 1;
        }
        return result.result();
    }

    private static final boolean canPrintLiterally$1(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c >= ' ' && c < '\u007f';
    }

    public static final /* synthetic */ StringBuilder $anonfun$escape$1(StringBuilder ret$1, boolean escapeUnicode$1, char c) {
        StringBuilder stringBuilder;
        char c2 = c;
        switch (c2) {
            case '\n': {
                stringBuilder = ret$1.$plus$plus$eq("\\n");
                break;
            }
            case '\r': {
                stringBuilder = ret$1.$plus$plus$eq("\\r");
                break;
            }
            case '\t': {
                stringBuilder = ret$1.$plus$plus$eq("\\t");
                break;
            }
            case '\b': {
                stringBuilder = ret$1.$plus$plus$eq("\\b");
                break;
            }
            case '\f': {
                stringBuilder = ret$1.$plus$plus$eq("\\f");
                break;
            }
            case '\\': {
                stringBuilder = ret$1.$plus$plus$eq("\\\\");
                break;
            }
            case '\"': {
                stringBuilder = ret$1.$plus$plus$eq("\\\"");
                break;
            }
            default: {
                if (!escapeUnicode$1 || StringUtils$.canPrintLiterally$1(c2)) {
                    stringBuilder = (StringBuilder)ret$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)c2));
                    break;
                }
                stringBuilder = ret$1.$plus$plus$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c2)})));
                break;
            }
        }
        return stringBuilder;
    }

    private StringUtils$() {
    }
}

