/*
 * Decompiled with CFR 0.152.
 */
package ru.makkarpov.scalingua.pofile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.makkarpov.scalingua.StringUtils$;
import ru.makkarpov.scalingua.pofile.Message;
import ru.makkarpov.scalingua.pofile.MessageLocation;
import ru.makkarpov.scalingua.pofile.MessageLocation$LocationOrdering$;
import ru.makkarpov.scalingua.pofile.MultipartString;
import ru.makkarpov.scalingua.pofile.NewLinePrintWriter;
import ru.makkarpov.scalingua.pofile.parse.ErrorReportingParser;
import ru.makkarpov.scalingua.pofile.parse.PoLexer;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PoFile$ {
    public static final PoFile$ MODULE$ = new PoFile$();
    private static final Charset encoding = StandardCharsets.UTF_8;
    private static final String GeneratedPrefix = "!Generated:";

    public Charset encoding() {
        return encoding;
    }

    public String GeneratedPrefix() {
        return GeneratedPrefix;
    }

    private String headerComment(String s) {
        return new StringBuilder(4).append("#  ").append(this.GeneratedPrefix()).append(" ").append(s).toString();
    }

    public Seq<Message> apply(File f) {
        return this.apply(new FileInputStream(f), f.getName());
    }

    public Seq<Message> apply(InputStream is, String filename) {
        ErrorReportingParser parser = new ErrorReportingParser(new PoLexer(new InputStreamReader(is, StandardCharsets.UTF_8), filename));
        return (Seq)parser.parse().value;
    }

    public String apply$default$2() {
        return "<unknown>";
    }

    public void update(File f, Seq<Message> messages, boolean escapeUnicode, boolean includeHeaderComment) {
        try (NewLinePrintWriter output = new NewLinePrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), this.encoding()), false);){
            if (includeHeaderComment) {
                output.println(this.headerComment(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())));
                output.println();
            }
            messages.foreach((Function1 & Serializable)m -> {
                PoFile$.$anonfun$update$2(output, escapeUnicode, m);
                return BoxedUnit.UNIT;
            });
        }
    }

    public boolean update$default$3() {
        return true;
    }

    public boolean update$default$4() {
        return true;
    }

    private static final void printEntry$1(String s, MultipartString m, NewLinePrintWriter output$1, boolean escapeUnicode$1) {
        output$1.print(new StringBuilder(1).append(s).append(" ").toString());
        if (m.parts().isEmpty()) {
            output$1.println("\"\"");
        } else {
            m.parts().foreach((Function1 & Serializable)p -> {
                output$1.println(new StringBuilder(2).append("\"").append(StringUtils$.MODULE$.escape(p, escapeUnicode$1)).append("\"").toString());
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$update$5(NewLinePrintWriter output$1, MessageLocation s) {
        if (s.line() < 0) {
            output$1.println(new StringBuilder(3).append("#: ").append(s.fileString()).toString());
        } else {
            output$1.println(new StringBuilder(4).append("#: ").append(s.fileString()).append(":").append(s.line()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$update$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$update$10(NewLinePrintWriter output$1, boolean escapeUnicode$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MultipartString m = (MultipartString)tuple2._1();
        int i = tuple2._2$mcI$sp();
        PoFile$.printEntry$1(new StringBuilder(8).append("msgstr[").append(i).append("]").toString(), m, output$1, escapeUnicode$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$update$2(NewLinePrintWriter output$1, boolean escapeUnicode$1, Message m) {
        m.header().comments().foreach((Function1 & Serializable)s -> {
            output$1.println(new StringBuilder(3).append("#  ").append(s).toString());
            return BoxedUnit.UNIT;
        });
        m.header().extractedComments().foreach((Function1 & Serializable)s -> {
            output$1.println(new StringBuilder(3).append("#. ").append(s).toString());
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)m.header().locations().sorted((Ordering)MessageLocation$LocationOrdering$.MODULE$)).foreach((Function1 & Serializable)s -> {
            PoFile$.$anonfun$update$5(output$1, s);
            return BoxedUnit.UNIT;
        });
        if (m.header().flags().nonEmpty()) {
            output$1.println(new StringBuilder(0).append("#, ").append(m.header().flags().map((Function1 & Serializable)x$1 -> x$1.toString(), (Ordering)Ordering.String$.MODULE$).mkString(", ")).toString());
        }
        m.header().tag().foreach((Function1 & Serializable)t -> {
            output$1.println(new StringBuilder(3).append("#~ ").append(t).toString());
            return BoxedUnit.UNIT;
        });
        m.context().foreach((Function1 & Serializable)c -> {
            PoFile$.printEntry$1("msgctxt", c, output$1, escapeUnicode$1);
            return BoxedUnit.UNIT;
        });
        PoFile$.printEntry$1("msgid", m.message(), output$1, escapeUnicode$1);
        Message message = m;
        if (message instanceof Message.Singular) {
            Message.Singular singular = (Message.Singular)message;
            MultipartString tr = singular.translation();
            PoFile$.printEntry$1("msgstr", tr, output$1, escapeUnicode$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (message instanceof Message.Plural) {
            Message.Plural plural = (Message.Plural)message;
            MultipartString id = plural.plural();
            Seq<MultipartString> trs = plural.translations();
            PoFile$.printEntry$1("msgid_plural", id, output$1, escapeUnicode$1);
            ((IterableOps)trs.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)PoFile$.$anonfun$update$9(check$ifrefutable$1))).foreach((Function1 & Serializable)x$2 -> {
                PoFile$.$anonfun$update$10(output$1, escapeUnicode$1, x$2);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)message);
        }
        output$1.println();
    }

    private PoFile$() {
    }
}

