/*
 * Decompiled with CFR 0.152.
 */
package ru.makkarpov.scalingua.pofile.shaded_javacup;

import java.util.HashMap;
import java.util.List;
import ru.makkarpov.scalingua.pofile.shaded_javacup.XMLElement;

public class SyntaxTreeDFS {
    public static void dfs(XMLElement element, Visitor visitor) {
        visitor.preVisit(element);
        for (XMLElement el : element.getChildren()) {
            SyntaxTreeDFS.dfs(el, visitor);
        }
        visitor.postVisit(element);
    }

    public static interface Visitor {
        public void preVisit(XMLElement var1);

        public void postVisit(XMLElement var1);
    }

    public static abstract class AbstractVisitor
    implements Visitor {
        private HashMap<String, ElementHandler> preMap = new HashMap();
        private HashMap<String, ElementHandler> postMap = new HashMap();

        public abstract void defaultPre(XMLElement var1, List<XMLElement> var2);

        public abstract void defaultPost(XMLElement var1, List<XMLElement> var2);

        @Override
        public void preVisit(XMLElement element) {
            ElementHandler handler = this.preMap.get(element.tagname);
            if (handler == null) {
                this.defaultPre(element, element.getChildren());
            } else {
                handler.handle(element, element.getChildren());
            }
        }

        @Override
        public void postVisit(XMLElement element) {
            ElementHandler handler = this.postMap.get(element.tagname);
            if (handler == null) {
                this.defaultPost(element, element.getChildren());
            } else {
                handler.handle(element, element.getChildren());
            }
        }

        public void registerPreVisit(String s, ElementHandler h) {
            this.preMap.put(s, h);
        }

        public void registerPostVisit(String s, ElementHandler h) {
            this.postMap.put(s, h);
        }
    }

    public static interface ElementHandler {
        public void handle(XMLElement var1, List<XMLElement> var2);
    }
}

