/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.qatools.gridrouter.config.Host;
import ru.qatools.gridrouter.config.HostSelectionStrategy;
import ru.qatools.gridrouter.config.Region;
import ru.qatools.gridrouter.config.WithCount;

public class RandomHostSelectionStrategy
implements HostSelectionStrategy {
    protected <T extends WithCount> T selectRandom(List<T> elements) {
        ArrayList<WithCount> copies = new ArrayList<WithCount>();
        for (WithCount element : elements) {
            copies.addAll(Collections.nCopies(element.getCount(), element));
        }
        Collections.shuffle(copies);
        return (T)((WithCount)copies.get(0));
    }

    @Override
    public Region selectRegion(List<Region> allRegions, List<Region> unvisitedRegions) {
        return this.selectRandom(unvisitedRegions);
    }

    @Override
    public Host selectHost(List<Host> hosts) {
        return this.selectRandom(hosts);
    }
}

