/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import ru.qatools.gridrouter.config.Browser;
import ru.qatools.gridrouter.config.Browsers;
import ru.qatools.gridrouter.config.Version;
import ru.qatools.gridrouter.json.JsonCapabilities;
import ru.qatools.gridrouter.utils.DirectoryWatcher;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class ConfigRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRepository.class);
    public static final String XML_GLOB = "*.xml";
    @Value(value="${grid.config.quota.directory}")
    private File quotaDirectory;
    @Value(value="${grid.config.quota.hotReload}")
    private boolean quotaHotReload;
    private Map<String, Browsers> userBrowsers = new HashMap();
    private Map<String, String> routes = new HashMap();
    private Thread quotaWatcherThread;

    @PostConstruct
    public void init() throws JAXBException, IOException {
        this.initBrowsers(this.getQuotaPath());
        if (this.isQuotaHotReload()) {
            this.startQuotaWatcher();
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.isQuotaHotReload()) {
            this.stopQuotaWatcher();
        }
    }

    private void startQuotaWatcher() {
        LOGGER.debug("Starting quota watcher");
        this.setQuotaWatcherThread(DirectoryWatcher.newWatcher((Path)this.getQuotaPath(), (String)"glob:*.xml", (kind, browserPath) -> {
            LOGGER.info("Reload configuration [{}] on event [{}]", (Object)browserPath, (Object)kind.name());
            this.initBrowsers(this.getQuotaPath());
        }));
        this.getQuotaWatcherThread().start();
    }

    private void stopQuotaWatcher() {
        LOGGER.debug("Stopping quota watcher");
        if (this.getQuotaWatcherThread() != null && this.getQuotaWatcherThread().isAlive()) {
            this.getQuotaWatcherThread().interrupt();
        }
    }

    public void initBrowsers(Path quotaPath) {
        HashMap<String, Browsers> temporaryUserBrowsers = new HashMap<String, Browsers>(this.getUserBrowsers());
        HashMap temporaryRoutes = new HashMap(this.getRoutes());
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(quotaPath, "*.xml");){
            for (Path browsersPath : stream) {
                LOGGER.info("Load configuration from [{}]", (Object)browsersPath);
                String user = ConfigRepository.getFileName((Path)browsersPath);
                try {
                    Browsers browsers = (Browsers)JAXB.unmarshal((File)browsersPath.toFile(), Browsers.class);
                    temporaryUserBrowsers.put(user, browsers);
                    temporaryRoutes.putAll(browsers.getRoutesMap());
                    LOGGER.info("Loaded configuration for [{}] from [{}]: \n\n{}", new Object[]{user, browsersPath, browsers.toXml()});
                }
                catch (Exception e) {
                    LOGGER.error("Loaded configuration failed for [{}]: \n\n{}", (Object)browsersPath, (Object)e);
                }
            }
            this.setUserBrowsers(temporaryUserBrowsers);
            this.setRoutes(temporaryRoutes);
        }
        catch (IOException e) {
            LOGGER.error("Loaded configuration failed: \n\n{}", (Throwable)e);
        }
    }

    protected boolean isQuotaHotReload() {
        return this.quotaHotReload;
    }

    protected Path getQuotaPath() {
        return this.quotaDirectory.toPath();
    }

    public Map<String, String> getRoutes() {
        return this.routes;
    }

    protected void setRoutes(Map<String, String> routes) {
        this.routes = routes;
    }

    public Map<String, Browsers> getUserBrowsers() {
        return this.userBrowsers;
    }

    protected Browsers getUserBrowsers(String user) {
        return (Browsers)this.getUserBrowsers().get(user);
    }

    protected void setUserBrowsers(Map<String, Browsers> userBrowsers) {
        this.userBrowsers = userBrowsers;
    }

    public Version findVersion(String user, JsonCapabilities caps) {
        return ((Browsers)this.userBrowsers.get(user)).find(caps.getBrowserName(), caps.getVersion());
    }

    private static String getFileName(Path path) {
        return FilenameUtils.getBaseName((String)path.toString());
    }

    public Map<String, Integer> getBrowsersCountMap(String user) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Browser browser : this.getUserBrowsers(user).getBrowsers()) {
            for (Version version : browser.getVersions()) {
                countMap.put(browser.getName() + ":" + version.getNumber(), version.getCount());
            }
        }
        return countMap;
    }

    public Thread getQuotaWatcherThread() {
        return this.quotaWatcherThread;
    }

    public void setQuotaWatcherThread(Thread quotaWatcherThread) {
        this.quotaWatcherThread = quotaWatcherThread;
    }
}

