/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import ru.qatools.gridrouter.ConfigRepository;
import ru.qatools.gridrouter.RequestUtils;
import ru.qatools.gridrouter.json.GridStats;
import ru.qatools.gridrouter.json.JsonMessage;
import ru.qatools.gridrouter.json.JsonMessageFactory;

@WebServlet(urlPatterns={"/wd/hub/session/*"}, asyncSupported=true, initParams={@WebInitParam(name="maxThreads", value="512"), @WebInitParam(name="timeout", value="300000"), @WebInitParam(name="idleTimeout", value="300000")})
public class ProxyServlet
extends org.eclipse.jetty.proxy.ProxyServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyServlet.class);
    public static final String WD_HUB_SESSION = "/wd/hub/session/";
    public static final int SESSION_HASH_LENGTH = 32;
    @Autowired
    private ConfigRepository config;
    @Autowired
    private GridStats stats;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    protected void sendProxyRequest(HttpServletRequest clientRequest, HttpServletResponse proxyResponse, Request proxyRequest) {
        try {
            Request request = this.getRequestWithoutSessionId(clientRequest, proxyRequest);
            super.sendProxyRequest(clientRequest, proxyResponse, request);
        }
        catch (Exception exception) {
            LOGGER.error("[{}] [{}] - could not read client request, proxying request as is", new Object[]{"REQUEST_READ_FAILURE", clientRequest.getRemoteHost(), exception});
            super.sendProxyRequest(clientRequest, proxyResponse, proxyRequest);
        }
    }

    protected String rewriteTarget(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String remoteHost = RequestUtils.getRemoteHost((HttpServletRequest)request);
        if (!this.isUriValid(uri)) {
            LOGGER.warn("[{}] [{}] - request uri is {}", new Object[]{"INVALID_SESSION_HASH", remoteHost, uri});
            return null;
        }
        String route = this.getRoute(uri);
        String command = this.getCommand(uri);
        if (route == null) {
            LOGGER.error("[{}] [{}] - request uri is {}", new Object[]{"ROUTE_NOT_FOUND", remoteHost, uri});
            return null;
        }
        if (this.isSessionDeleteRequest(request, command)) {
            LOGGER.info("[{}] [{}] [{}] [{}]", new Object[]{"SESSION_DELETED", remoteHost, route, command});
            this.stats.stopSession();
        }
        try {
            return this.redirectionUrl(route, command);
        }
        catch (Exception exception) {
            LOGGER.error("[{}] [{}] - error building redirection uri because of {}\n    request uri:    {}\n    parsed route:   {}\n    parsed command: {}", new Object[]{"REDIRECTION_URL_ERROR", remoteHost, exception.toString(), uri, route, command});
            return null;
        }
    }

    protected Request getRequestWithoutSessionId(HttpServletRequest clientRequest, Request proxyRequest) throws IOException {
        String content = IOUtils.toString((InputStream)clientRequest.getInputStream(), (Charset)StandardCharsets.UTF_8);
        if (!content.isEmpty()) {
            String remoteHost = RequestUtils.getRemoteHost((HttpServletRequest)clientRequest);
            content = this.removeSessionIdSafe(content, remoteHost);
        }
        return proxyRequest.content((ContentProvider)new StringContentProvider(clientRequest.getContentType(), content, StandardCharsets.UTF_8));
    }

    private String removeSessionIdSafe(String content, String remoteHost) {
        try {
            JsonMessage message = JsonMessageFactory.from((String)content);
            message.setSessionId(null);
            return message.toJson();
        }
        catch (IOException exception) {
            LOGGER.error("[{}] [{}] - could not create proxy request without session id, proxying request as is. Request content is: {}", new Object[]{"UNABLE_TO_REMOVE_SESSION_ID", remoteHost, content, exception});
            return content;
        }
    }

    protected String redirectionUrl(String host, String command) throws URISyntaxException {
        return new URIBuilder(host).setPath(WD_HUB_SESSION + command).build().toString();
    }

    protected String getRoute(String uri) {
        return (String)this.config.getRoutes().get(this.getSessionHash(uri));
    }

    protected String getCommand(String uri) {
        return uri.substring(this.getUriPrefixLength());
    }

    protected boolean isUriValid(String uri) {
        return uri.length() > this.getUriPrefixLength();
    }

    protected boolean isSessionDeleteRequest(HttpServletRequest request, String command) {
        return HttpMethod.DELETE.name().equalsIgnoreCase(request.getMethod()) && !command.contains("/");
    }

    protected String getSessionHash(String uri) {
        return uri.substring(WD_HUB_SESSION.length(), this.getUriPrefixLength());
    }

    protected int getUriPrefixLength() {
        return WD_HUB_SESSION.length() + 32;
    }
}

