/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;
import ru.qatools.gridrouter.ConfigRepository;
import ru.qatools.gridrouter.RequestUtils;
import ru.qatools.gridrouter.config.Host;
import ru.qatools.gridrouter.config.HostSelectionStrategy;
import ru.qatools.gridrouter.config.Region;
import ru.qatools.gridrouter.config.Version;
import ru.qatools.gridrouter.config.WithCopy;
import ru.qatools.gridrouter.json.GridStats;
import ru.qatools.gridrouter.json.JsonCapabilities;
import ru.qatools.gridrouter.json.JsonMessage;
import ru.qatools.gridrouter.json.JsonMessageFactory;

@WebServlet(urlPatterns={"/wd/hub/session"}, asyncSupported=true)
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user"}))
public class RouteServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteServlet.class);
    @Autowired
    private ConfigRepository config;
    @Autowired
    private HostSelectionStrategy hostSelectionStrategy;
    @Autowired
    private GridStats stats;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        SpringBeanAutowiringSupport.processInjectionBasedOnServletContext((Object)this, (ServletContext)config.getServletContext());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JsonMessage message = JsonMessageFactory.from((InputStream)request.getInputStream());
        JsonCapabilities caps = message.getDesiredCapabilities();
        String user = request.getRemoteUser();
        String remoteHost = RequestUtils.getRemoteHost((HttpServletRequest)request);
        String browser = caps.describe();
        Version actualVersion = this.config.findVersion(user, caps);
        if (actualVersion == null) {
            LOGGER.warn("[{}] [{}] [{}] [{}]", new Object[]{"UNSUPPORTED_BROWSER", user, remoteHost, browser});
            this.replyWithError(String.format("Cannot find %s capabilities on any available node", caps.describe()), response);
            return;
        }
        caps.setVersion(actualVersion.getNumber());
        List actualRegions = actualVersion.getRegions().stream().map(WithCopy::copy).collect(Collectors.toList());
        ArrayList unusedRegions = new ArrayList(actualRegions);
        int attempt = 0;
        while (!actualRegions.isEmpty()) {
            ++attempt;
            Region currentRegion = this.hostSelectionStrategy.selectRegion(unusedRegions);
            Host host = this.hostSelectionStrategy.selectHost(currentRegion.getHosts());
            String route = host.getRoute();
            try (CloseableHttpClient client = this.newHttpClient();){
                LOGGER.info("[{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{"SESSION_ATTEMPTED", user, remoteHost, browser, route, attempt});
                String target = route + request.getRequestURI();
                CloseableHttpResponse hubResponse = client.execute((HttpUriRequest)this.post(target, message));
                JsonMessage hubMessage = JsonMessageFactory.from((InputStream)hubResponse.getEntity().getContent());
                if (hubResponse.getStatusLine().getStatusCode() == 200) {
                    String sessionId = hubMessage.getSessionId();
                    hubMessage.setSessionId(host.getRouteId() + sessionId);
                    this.replyWithOk(hubMessage, response);
                    LOGGER.info("[{}] [{}] [{}] [{}] [{}] [{}] [{}]", new Object[]{"SESSION_CREATED", user, remoteHost, browser, route, sessionId, attempt});
                    this.stats.startSession();
                    return;
                }
                LOGGER.warn("[{}] [{}] [{}] [{}] [{}] - {}", new Object[]{"SESSION_FAILED", user, remoteHost, browser, route, hubMessage.getErrorMessage()});
            }
            catch (JsonProcessingException exception) {
                LOGGER.error("[{}] [{}] [{}] [{}] - {}", new Object[]{"BAD_HUB_JSON", user, remoteHost, browser, route, exception.getMessage()});
            }
            catch (IOException exception) {
                LOGGER.error("[{}] [{}] [{}] [{}] - {}", new Object[]{"HUB_COMMUNICATION_FAILURE", user, remoteHost, browser, route, exception.getMessage()});
            }
            currentRegion.getHosts().remove(host);
            if (currentRegion.getHosts().isEmpty()) {
                actualRegions.remove(currentRegion);
            }
            unusedRegions.remove(currentRegion);
            if (!unusedRegions.isEmpty()) continue;
            unusedRegions = new ArrayList(actualRegions);
        }
        LOGGER.error("[{}] [{}] [{}] [{}]", new Object[]{"SESSION_NOT_CREATED", user, remoteHost, browser});
        this.replyWithError("Cannot create session on any available node", response);
    }

    protected void replyWithOk(JsonMessage message, HttpServletResponse response) throws IOException {
        this.reply(200, message, response);
    }

    protected void replyWithError(String errorMessage, HttpServletResponse response) throws IOException {
        this.reply(500, JsonMessageFactory.error((int)13, (String)errorMessage), response);
    }

    protected void reply(int code, JsonMessage message, HttpServletResponse response) throws IOException {
        response.setStatus(code);
        response.setContentType(ContentType.APPLICATION_JSON.toString());
        String messageRaw = message.toJson();
        response.setContentLength(messageRaw.getBytes(StandardCharsets.UTF_8).length);
        try (ServletOutputStream output = response.getOutputStream();){
            IOUtils.write((String)messageRaw, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
    }

    protected HttpPost post(String target, JsonMessage message) throws IOException {
        HttpPost method = new HttpPost(target);
        StringEntity entity = new StringEntity(message.toJson(), ContentType.APPLICATION_JSON);
        method.setEntity((HttpEntity)entity);
        method.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        return method;
    }

    protected CloseableHttpClient newHttpClient() {
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectionRequestTimeout(10000).setConnectTimeout(10000).build()).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
    }
}

