/*
 * Decompiled with CFR 0.152.
 */
package ru.taskurotta.util;

import java.util.concurrent.ConcurrentMap;

public class Concurrent {
    public static <K, V> V getOrCreate(ConcurrentMap<K, V> map, K key, ValueFactory<V> factory) {
        Object value = map.get(key);
        if (value != null) {
            return value;
        }
        V newValue = factory.newInstance();
        value = map.putIfAbsent(key, newValue);
        if (value != null) {
            return value;
        }
        return newValue;
    }

    public static <K, V> V getOrCreate(ConcurrentMap<K, V> map, K key, ValueFactoryAndCallback<V> factory) {
        Object value = map.get(key);
        if (value != null) {
            return value;
        }
        V newValue = factory.newInstance();
        value = map.putIfAbsent(key, newValue);
        if (value != null) {
            return value;
        }
        factory.callback(newValue);
        return newValue;
    }

    public static interface ValueFactoryAndCallback<T> {
        public T newInstance();

        public void callback(T var1);
    }

    public static interface ValueFactory<T> {
        public T newInstance();
    }
}

