/*
 * Decompiled with CFR 0.152.
 */
package ru.taskurotta.util;

import java.util.concurrent.TimeUnit;
import ru.taskurotta.util.Shutdown;

public abstract class DaemonThread
extends Thread {
    TimeUnit sleepUnit;
    long sleepValue;

    public DaemonThread(String name, TimeUnit sleepUnit, long sleepValue) {
        super(name);
        this.sleepUnit = sleepUnit;
        this.sleepValue = sleepValue;
    }

    @Override
    public final void run() {
        while (!Shutdown.isTrue() && !this.isInterrupted()) {
            try {
                this.daemonJob();
            }
            catch (StopSignal signal) {
                return;
            }
            if (this.sleepUnit == null) continue;
            try {
                this.sleepUnit.sleep(this.sleepValue);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public abstract void daemonJob();

    public static class StopSignal
    extends RuntimeException {
    }
}

