/*
 * Decompiled with CFR 0.152.
 */
package ru.taskurotta.util;

import java.util.Formatter;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryAllocationConfigurator {
    private static final Logger logger = LoggerFactory.getLogger(MemoryAllocationConfigurator.class);
    public static final String AUTO_ENABLED = "taskurotta.memory.auto";
    public static final String AUTO_PROPORTIONS = "taskurotta.memory.config";
    public static final String MAP_PROCESS_SIZE = "hz.map.process.memory.max-size";
    public static final String MAP_GRAPH_SIZE = "hz.map.graph.memory.max-size";
    public static final String MAP_GRAPH_DECISION = "hz.map.graph-decision.memory.max-size";
    public static final String MAP_TASK_SIZE = "hz.map.task.memory.max-size";
    public static final String MAP_TASK_DECISION_SIZE = "hz.map.decision.memory.max-size";
    public static final String QUEUES = "hz.queue.memory.max-size";

    public static void main(String[] args) {
        System.setProperty(AUTO_ENABLED, "true");
        System.setProperty(AUTO_PROPORTIONS, "c:60Mb f:30% (p:21 g:25 gd:1 t:22 td:20 q:200)");
        MemoryAllocationConfigurator.calculate(System.getProperties());
    }

    public static Properties calculate(Properties properties) {
        Properties resultProperties = new Properties();
        Boolean isEnabled = MemoryAllocationConfigurator.getBooleanProperty(properties, AUTO_ENABLED);
        if (isEnabled == null || !isEnabled.booleanValue()) {
            return resultProperties;
        }
        int[] data = MemoryAllocationConfigurator.getProportionProperty(properties, AUTO_PROPORTIONS);
        long totalMemory = Runtime.getRuntime().totalMemory();
        long withoutKernelMemory = totalMemory - (long)(data[0] * 1024 * 1024);
        long freeMemory = (long)(1.0 * (double)withoutKernelMemory / 100.0 * (double)data[1]);
        long collectionsMemory = withoutKernelMemory - freeMemory;
        int sumOfProportions = 0;
        for (int i = 2; i < 8; ++i) {
            sumOfProportions += data[i];
        }
        logger.info("Automatic memory calibration: ");
        long onePartSize = collectionsMemory / (long)sumOfProportions;
        logger.info("Total memory: {}Mb", (Object)MemoryAllocationConfigurator.bytesToMb(totalMemory));
        logger.info("Kernel size: {}Mb", (Object)data[0]);
        logger.info("Free memory {}%: {}Mb", (Object)data[1], (Object)MemoryAllocationConfigurator.bytesToMb(freeMemory));
        logger.info("One of {} parts size: {}Mb", (Object)sumOfProportions, (Object)MemoryAllocationConfigurator.bytesToMb(onePartSize));
        logger.info("Maximum memory of all collections: {}Mb", (Object)MemoryAllocationConfigurator.bytesToMb(collectionsMemory));
        MemoryAllocationConfigurator.setAndPrint(resultProperties, MAP_PROCESS_SIZE, totalMemory, onePartSize, data[2]);
        MemoryAllocationConfigurator.setAndPrint(resultProperties, MAP_GRAPH_SIZE, totalMemory, onePartSize, data[3]);
        MemoryAllocationConfigurator.setAndPrint(resultProperties, MAP_GRAPH_DECISION, totalMemory, onePartSize, data[4]);
        MemoryAllocationConfigurator.setAndPrint(resultProperties, MAP_TASK_SIZE, totalMemory, onePartSize, data[5]);
        MemoryAllocationConfigurator.setAndPrint(resultProperties, MAP_TASK_DECISION_SIZE, totalMemory, onePartSize, data[6]);
        MemoryAllocationConfigurator.setAndPrint(resultProperties, QUEUES, totalMemory, onePartSize, data[7]);
        return resultProperties;
    }

    private static void setAndPrint(Properties properties, String propertyName, long collectionsMemory, long onePartSize, int parts) {
        long size = onePartSize * (long)parts;
        int percentage = (int)(1.0 * (double)size / (double)collectionsMemory * 100.0);
        percentage = percentage == 0 ? 1 : percentage;
        long actualSize = (long)(1.0 * (double)Runtime.getRuntime().totalMemory() / 100.0 * (double)percentage);
        properties.setProperty(propertyName, "" + percentage);
        logger.info("Add property \"{}\" with value {}% = {} Mb ({} parts)", new Object[]{propertyName, percentage, MemoryAllocationConfigurator.bytesToMb(actualSize), parts});
    }

    private static String bytesToMb(long bytes) {
        return new Formatter().format("%6.2f", (double)bytes / 1024.0 / 1024.0).toString();
    }

    public static int[] getProportionProperty(Properties properties, String name) {
        String value = System.getProperty(name);
        if (value == null && (value = properties.getProperty(name)) == null) {
            throw new IllegalArgumentException("Required property [" + name + "] not found");
        }
        int[] data = new int[]{MemoryAllocationConfigurator.getProportion(value, "k"), MemoryAllocationConfigurator.getProportion(value, "f"), MemoryAllocationConfigurator.getProportion(value, "p"), MemoryAllocationConfigurator.getProportion(value, "g"), MemoryAllocationConfigurator.getProportion(value, "gd"), MemoryAllocationConfigurator.getProportion(value, "t"), MemoryAllocationConfigurator.getProportion(value, "td"), MemoryAllocationConfigurator.getProportion(value, "q")};
        return data;
    }

    private static int getProportion(String value, String prefix) {
        String digits;
        int result;
        Pattern pattern = Pattern.compile("(?<=" + prefix + ":)\\d+");
        Matcher matcher = pattern.matcher(value);
        if (!matcher.find()) {
            new IllegalArgumentException("Can not find value of [" + prefix + "] on proportions property [" + value + "]");
        }
        if ((result = Integer.parseInt(digits = matcher.group())) == 0) {
            new IllegalArgumentException("Property [" + value + "] has zero value of [" + prefix + "]");
        }
        return result;
    }

    public static Boolean getBooleanProperty(Properties properties, String name) {
        String value = System.getProperty(name);
        if (value == null && (value = properties.getProperty(name)) == null) {
            return null;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Wrong format of boolean property [" + name + "] Its value is [" + value + "]");
        }
    }
}

