/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.gatling.influxdb;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.razem.influxdbclient.InfluxDB;
import io.razem.influxdbclient.Point;
import io.razem.influxdbclient.QueryResult;
import io.razem.influxdbclient.Record;
import io.razem.influxdbclient.Series;
import java.io.Serializable;
import ru.tinkoff.gatling.influxdb.Start$;
import ru.tinkoff.gatling.influxdb.Status;
import ru.tinkoff.gatling.influxdb.Stop$;
import ru.tinkoff.gatling.influxdb.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class AnnotationManager$
implements StrictLogging {
    public static final AnnotationManager$ MODULE$ = new AnnotationManager$();
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private <T> void completeAddStatusAnnotation(InfluxDB connection, Status status, Future<T> res) {
        res.onComplete((Function1 & Serializable)x0$1 -> {
            Future<BoxedUnit> future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("{} annotation has been written to influxdb", (Object)status);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = package$.MODULE$.influx().close(connection);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error("Failed to write {} annotation to influxdb: {}", new Object[]{status, exception.getMessage()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = package$.MODULE$.influx().close(connection);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private <T> void completeWrite(InfluxDB connection, Future<T> res) {
        res.onComplete((Function1 & Serializable)x0$1 -> {
            Future<BoxedUnit> future;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                if (MODULE$.logger().underlying().isInfoEnabled()) {
                    MODULE$.logger().underlying().info("Custom point has been written to influxdb");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = package$.MODULE$.influx().close(connection);
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (MODULE$.logger().underlying().isErrorEnabled()) {
                    MODULE$.logger().underlying().error("Failed to write custom point to influxdb: {}", (Object)exception.getMessage());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                future = package$.MODULE$.influx().close(connection);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BigDecimal> incrementStatusAnnotationValue(Status status, QueryResult res) {
        Future future;
        Status status2 = status;
        if (Start$.MODULE$.equals(status2)) {
            future = AnnotationManager$.incrementAndGet$1(1, res);
        } else if (Stop$.MODULE$.equals(status2)) {
            future = AnnotationManager$.incrementAndGet$1(0, res);
        } else {
            throw new MatchError((Object)status2);
        }
        return future;
    }

    public void addStatusAnnotation(Status status) {
        package$.MODULE$.influx().init().flatMap((Function1 & Serializable)connection -> package$.MODULE$.influx().readLastStatusAnnotation((InfluxDB)connection).flatMap((Function1 & Serializable)lastValue -> MODULE$.incrementStatusAnnotationValue(status, (QueryResult)lastValue).map((Function1 & Serializable)value -> {
            Future<Object> res = package$.MODULE$.influx().writeStatusAnnotation((InfluxDB)connection, status, (BigDecimal)value, System.currentTimeMillis() * 1000000L);
            return new Tuple2(value, res);
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable)x$1 -> {
            AnnotationManager$.$anonfun$addStatusAnnotation$4(connection, status, x$1);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public void addCustomAnnotation(String tagKey, String tagValue, String fieldKey, String fieldValue) {
        package$.MODULE$.influx().init().map((Function1 & Serializable)connection -> {
            Future<Object> res = package$.MODULE$.influx().writeCustomAnnotation((InfluxDB)connection, tagKey, tagValue, fieldKey, fieldValue, System.currentTimeMillis() * 1000000L);
            return new Tuple2(connection, res);
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable)x$2 -> {
            AnnotationManager$.$anonfun$addCustomAnnotation$2(x$2);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public void addCustomPoint(Point point) {
        package$.MODULE$.influx().init().map((Function1 & Serializable)connection -> {
            Future<Object> res = package$.MODULE$.influx().writeCustomPoint((InfluxDB)connection, point);
            return new Tuple2(connection, res);
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable)x$3 -> {
            AnnotationManager$.$anonfun$addCustomPoint$2(x$3);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public void addCustomPoints(Seq<Point> points) {
        package$.MODULE$.influx().init().map((Function1 & Serializable)connection -> {
            Future<Object> res = package$.MODULE$.influx().writeCustomPoints((InfluxDB)connection, points);
            return new Tuple2(connection, res);
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable)x$4 -> {
            AnnotationManager$.$anonfun$addCustomPoints$2(x$4);
            return BoxedUnit.UNIT;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private static final Future incrementAndGet$1(int i, QueryResult res$1) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> scala.package$.MODULE$.BigDecimal().apply(((Record)((Series)res$1.series().last()).records().last()).allValues().last().toString()).$plus(BigDecimal$.MODULE$.int2bigDecimal(i)), ExecutionContext.Implicits$.MODULE$.global()).recover((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1 != null ? scala.package$.MODULE$.BigDecimal().apply(0) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public static final /* synthetic */ void $anonfun$addStatusAnnotation$4(InfluxDB connection$3, Status status$2, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Future res = (Future)tuple2._2();
        MODULE$.completeAddStatusAnnotation(connection$3, status$2, res);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$addCustomAnnotation$2(Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InfluxDB connection = (InfluxDB)tuple2._1();
        Future res = (Future)tuple2._2();
        MODULE$.completeWrite(connection, res);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$addCustomPoint$2(Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InfluxDB connection = (InfluxDB)tuple2._1();
        Future res = (Future)tuple2._2();
        MODULE$.completeWrite(connection, res);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$addCustomPoints$2(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InfluxDB connection = (InfluxDB)tuple2._1();
        Future res = (Future)tuple2._2();
        MODULE$.completeWrite(connection, res);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private AnnotationManager$() {
    }
}

